xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms 
    of the GNU Affero General Public Licenseas published by the Free Software Foundation; 
    either version 3 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
    See the GNU Affero General Public Licensefor more details.
    
    See http://www.gnu.org/licenses/
:)
import module namespace ada     = "http://art-decor.org/ns/ada-common" at "ada-common.xqm";
import module namespace adaxml  = "http://art-decor.org/ns/ada-xml" at "ada-xml.xqm";

declare namespace request   = "http://exist-db.org/xquery/request";
declare namespace response  = "http://exist-db.org/xquery/response";
declare option exist:serialize "method=xhtml media-type=text/html indent=yes";

let $app            := if (request:exists()) then request:get-parameter('app','') else 'demoapp' 

let $data           := $ada:colAdaData//adaxml/data/*[@app=$app]
let $result         := 
    if (not($data)) 
    then concat('No data found for app ', $app) 
    else 
    let $definition     := ada:getTransactionDataset($data[1])
    return
        <html>
           <head>
              <title>Coverage for {$definition/name}</title>
              <link rel="stylesheet" type="text/css" href="../resources/css/ada.css"/>
            </head>
            <body class="orbeon ada">
                <h1>Coverage for {$definition/name}</h1>
                <table>
                    <tr>
                        <th>Concept</th>
                        <th>Id</th>
                        <th>Type</th>
                        <th>Touched</th>
                    </tr>
                    {
                    for $concept in $definition//concept[@type=('item', 'group')]
                    let $touched :=
                        if ($concept[@type='item'])
                        then count($data//*[@value][@conceptId=$concept/@id])
                        else count($data//*[empty(@hidden)][@conceptId=$concept/@id])
                    return 
                    <tr style="{if ($touched=0) then 'background-color:lightpink;' else ''}">
                        <td>{$concept/name}</td>
                        <td>{$concept/@id/string()}</td>
                        <td>{$concept/@type/string()}</td>
                        <td>{$touched}</td>
                    </tr>
                    }
                </table>
            </body>
        </html>
return if ($data) then $result else (if (request:exists()) then response:set-status-code(404) else (), $result)