xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms 
    of the GNU Affero General Public Licenseas published by the Free Software Foundation; 
    either version 3 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
    See the GNU Affero General Public Licensefor more details.
    
    See http://www.gnu.org/licenses/
:)
import module namespace ada     = "http://art-decor.org/ns/ada-common" at "ada-common.xqm";
import module namespace adaxml  = "http://art-decor.org/ns/ada-xml" at "ada-xml.xqm";

declare namespace request   = "http://exist-db.org/xquery/request";
declare namespace response  = "http://exist-db.org/xquery/response";

let $id         := if (request:exists()) then request:get-parameter('id','') else 'c1bb078c-21e4-4330-b761-c069afb3b33a'
let $app        := if (request:exists()) then request:get-parameter('app','') else ''
let $data       := ada:getCollection($app, 'data')//*[@app = $app][@id = $id]

return 
    if (string-length($app) = 0 or string-length($id) = 0) then (
        if (request:exists()) then response:set-status-code(400) else (),
        <error>Missing parameter app='{$app}' or id='{$id}'</error>
    )
    else
    if (ada:hasPermission($data, 'delete')) then (
        if (request:exists()) then response:set-status-code(200) else (),
        xmldb:remove(util:collection-name($data), util:document-name($data))
    )
    else (
        if (request:exists()) then response:set-status-code(401) else (),
        <error>Only the creator may delete a record</error>
    )
