xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms 
    of the GNU Affero General Public Licenseas published by the Free Software Foundation; 
    either version 3 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
    See the GNU Affero General Public Licensefor more details.
    
    See http://www.gnu.org/licenses/
:)
import module namespace ada     = "http://art-decor.org/ns/ada-common" at "ada-common.xqm";
import module namespace adaxml  = "http://art-decor.org/ns/ada-xml" at "ada-xml.xqm";

declare namespace request   = "http://exist-db.org/xquery/request";
declare namespace response  = "http://exist-db.org/xquery/response";

let $params         := if (request:exists()) then request:get-data()/* else <rename app="demo1" id="demo1-ttt-01" newid="demo1-ttt-02"/>

let $app        := if ($params) then $params/@app else if (request:exists()) then request:get-parameter('app', ()) else 'demoapp'
let $id        := if ($params) then $params/@id else if (request:exists()) then request:get-parameter('id', ()) else 'demo1-ttt-01'
let $newid      := if ($params) then $params/@newid else if (request:exists()) then request:get-parameter('newid', ()) else 'demo1-ttt-03'
(: if multiple exist, move the first. This may be used as a means for deduplication :)
let $olddata    := (ada:getCollection($app, 'data')//*[@app = $app][@id = $id])[1]
let $newdata    := ada:getCollection($app, 'data')//*[@app = $app][@id = $newid]

let $colName    := util:collection-name($olddata)
let $newName    := concat($newid, '.xml')
return 
    if (string-length($app) = 0 or string-length($id) = 0 or string-length($newid) = 0) then (
        if (request:exists()) then response:set-status-code(400) else (),
        <error>Missing parameter app='{$app}' or id='{$id}' or newid='{$newid}'</error>
    )
    else
    if ($id = $newid) then (
        if (request:exists()) then response:set-status-code(400) else (),
        <error>Cannot rename to newid: id='{$id}' is equal to newid='{$newid}'</error>
    )
    else
    if (empty($olddata)) then (
        if (request:exists()) then response:set-status-code(400) else (),
        <error>Cannot rename to newid: source does not exist</error>
    )
    else
    if ($newdata) then (
        if (request:exists()) then response:set-status-code(400) else (),
        <error>Cannot use newid: already exists</error>
    )
    else
    if (ada:hasPermission($olddata, 'update')) then (
        if (request:exists()) then response:set-status-code(200) else (),
        xmldb:rename($colName, util:document-name($olddata), $newName),
        (: in case we're mooving a duplicate id, we cannot rely on collection() selection :)
        update value doc(concat($colName, '/', $newName))//*[@app = $app][@id = $id]/@id with $newid
    )
    else (
        if (request:exists()) then response:set-status-code(401) else (),
        <error>Only the creator may update a record</error>
    )
