(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms 
    of the GNU Affero General Public Licenseas published by the Free Software Foundation; 
    either version 3 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
    See the GNU Affero General Public Licensefor more details.
    
    See http://www.gnu.org/licenses/
:)
xquery version "3.0";

import module namespace ada ="http://art-decor.org/ns/ada-common" at "ada-common.xqm";
import module namespace adaxml ="http://art-decor.org/ns/ada-xml" at "ada-xml.xqm";

declare namespace request   = "http://exist-db.org/xquery/request";
declare namespace response  = "http://exist-db.org/xquery/response";

let $data       := if (request:exists()) then request:get-data()/* else ()

(: Don't log data in controller, since get-data removes them from request :)
let $logOn      := 
    if ($ada:logOn) then (
        let $log := <data>{$data}</data>
        (: don't store if not logged in or log not available :)
        return  
            try {xmldb:store($ada:strAdaLog, concat('DATA', '-', $data/@app, '-', substring(translate(xs:string(current-dateTime()), ':T-.+', ''),1,17), '.xml'), $log)}
            catch * {()}
     )
     else ()
let $result     := 
    try {adaxml:saveAdaXml($data)}
    catch * {
        <error>Caught error {$err:code}: {$err:description}</error>
    }
let $logOn      := if ($ada:logOn) then ada:log('save-data-result', $data/@app, $result) else ()
return 
    if (local-name($result) = 'error') then (
        if (request:exists()) then response:set-status-code(400) else (),
        $result
    )
    else (
        if (request:exists()) then (if ($data/@id = 'new') then response:set-status-code(201) else response:set-status-code(200)) else (),
        adaxml:getXmlData($data/@app, $result, (), 'false', $data/@transactionRef, $data/@transactionEffectiveDate)
    )