xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms 
    of the GNU General Public License as published by the Free Software Foundation; 
    either version 3 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
    See the GNU General Public License for more details.
    
    See http://www.gnu.org/licenses/gpl.html
:)
import module namespace ada     = "http://art-decor.org/ns/ada-common" at "../modules/ada-common.xqm";
declare namespace xmldb         = "http://exist-db.org/xquery/xmldb";
declare namespace sm            = "http://exist-db.org/xquery/securitymanager";
declare namespace output        = "http://www.w3.org/2010/xslt-xquery-serialization";
declare option output:method "xml";

declare %private function local:get-project($diskRoot, $project) {
    let $adaDir     := concat($diskRoot, $project, '\') 
    let $adaRoot    := concat($ada:strAdaProjects,'/', $project, '/')
    
    let $collections := if (xmldb:collection-available($adaRoot)) then () else  
        <result>
        {
            let $datadir    := xmldb:create-collection($ada:strAdaData, $project)
            let $cc         := xmldb:create-collection($datadir, 'data')
            let $projectdir := xmldb:create-collection($ada:strAdaProjects, $project)
            let $cc         := xmldb:create-collection($projectdir, 'schemas')
            let $cc         := xmldb:create-collection($projectdir, 'new')
            let $cc         := xmldb:create-collection($projectdir, 'modules')
            let $cc         := xmldb:create-collection($projectdir, 'views')
            let $cc         := xmldb:create-collection($projectdir, 'definitions')
            return <dir>{$cc}</dir>
        }
        </result>

    let $empty := 
        for $child in xmldb:get-child-resources($adaRoot)
        return xmldb:remove($adaRoot, $child)
    
    let $empty :=
    for $childcoll in xmldb:get-child-collections($adaRoot)
    return
        for $child in xmldb:get-child-resources(concat($adaRoot, $childcoll))
        return xmldb:remove(concat($adaRoot, $childcoll), $child)
        
    let $result :=
        <result>
            <definitions>
            {
                for $f in xmldb:store-files-from-pattern(concat($adaRoot, 'definitions'), concat($adaDir, 'definitions'), '*.xml') 
                return <file>{$f}</file>
            }
            </definitions>
            <schemas>
            {
                for $f in xmldb:store-files-from-pattern(concat($adaRoot, 'schemas'), concat($adaDir, 'schemas'), '*.xsd') 
                return <file>{$f}</file>
            }
            </schemas>
            <!--js>
            {
                for $f in xmldb:store-files-from-pattern(concat($adaRoot, 'js'), concat($adaDir, 'js'), ('*.js')) 
                return <file>{$f}</file>
            }
            </js-->
            <!--modules>
            {
                for $f in xmldb:store-files-from-pattern(concat($adaRoot, 'modules'), concat($adaDir, 'modules'), ('*.xquery')) 
                return <file>{$f}</file>
            }
            </modules-->
            <views>
            {
                for $f in xmldb:store-files-from-pattern(concat($adaRoot, 'views'), concat($adaDir, 'views'), ('*.xhtml', '*.html')) 
                return <file>{$f}</file>
            }
            </views>
            <new>
            {
                for $f in xmldb:store-files-from-pattern(concat($adaRoot, 'new'), concat($adaDir, 'new'), '*.xml') 
                return <file>{$f}</file>
            }
            </new>
            <root>
            {
                for $f in xmldb:store-files-from-pattern($adaRoot, $adaDir, ('*.xml', '*.xql')) 
                return <file>{$f}</file>
            }
            </root>
        </result>
    let $permissions := ada:setPermissions($project)
    return $result
};

let $diskRoot   := 'C:\Dev\Source\ART DECOR trunk\ada-data\projects\' 
let $result     := ()
let $projects   := ('e-overdracht')
let $result     := 
    for $project in $projects
    return ($result, local:get-project($diskRoot, $project))
return $result