(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms 
    of the GNU General Public License as published by the Free Software Foundation; 
    either version 3 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
    See the GNU General Public License for more details.
    
    See http://www.gnu.org/licenses/gpl.html
:)
xquery version "1.0";

import module namespace xmldb   = "http://exist-db.org/xquery/xmldb";
import module namespace ada     = "http://art-decor.org/ns/ada-common" at "../modules/ada-common.xqm";
import module namespace adpfix  = "http://art-decor.org/ns/ada/permissions" at "../api/api-permissions.xqm";

let $project    := if (request:exists()) then request:get-parameter('project',()) else 'mp-mp9'

let $update     := adpfix:setAdaPermissions()

return 
    if ($project) then (
        ada:setPermissions($project)
    )
    else (
        for $project in xmldb:get-child-collections($ada:strAdaProjects)
        return
        ada:setPermissions($project)
    )