(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms 
    of the GNU General Public License as published by the Free Software Foundation; 
    either version 3 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
    See the GNU General Public License for more details.
    
    See http://www.gnu.org/licenses/gpl.html
:)
xquery version "3.0";
declare option exist:serialize "method=xhtml media-type=text/html indent=yes";
import module namespace ada ="http://art-decor.org/ns/ada-common" at "ada-common.xqm";

<html>
    <head>
        <title>ADA Logging</title>
        <link rel="stylesheet" type="text/css" href="../resources/css/ada.css"/>
    </head>
    <body class="orbeon ada">
        <h1>ADA Logging</h1>
        <p>Logged in as: {ada:strCurrentUserName()}</p>
        <p>Logging is turned {if ($ada:logOn) then 'ON' else 'OFF'} (Press F5 to refresh)</p>
        <p><a href="toggle-logging.xquery">Turn logging {if ($ada:logOn) then 'OFF' else 'ON'}</a></p>
        <p><a href="clear-log.xquery">Clear log</a></p>
        <table>
        {
            for $resource in xmldb:get-child-resources($ada:strAdaLog)
            let $created := xmldb:created($ada:strAdaLog, $resource)
            order by $created descending
            return 
                <tr>
                    <td>{$created}</td>
                    <td><a href="../../ada-data/log/{$resource}">{$resource}</a></td>
                </tr>
        }
        </table>
    </body>
</html>