xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

declare namespace sm           = "http://exist-db.org/xquery/securitymanager";
declare namespace request      = "http://exist-db.org/xquery/request";
declare namespace response     = "http://exist-db.org/xquery/response";

let $test       := request:get-data()/user
let $user       := ($test/username, 'guest')[1]
let $pwd        := $test/password
let $create     := session:create()

return
if (xmldb:authenticate('/db',$user,$pwd)) then
    let $login              := xmldb:login('/db', $user, $pwd, true())
    let $username           := ada:strCurrentUserName()
    let $groups             := sm:get-user-groups($username)
    return
        <user>
            <username>{data($username)}</username>
            <groups>{$groups}</groups>
            <password>{data($pwd)}</password>
            <logged-in>true</logged-in>
        </user>
else (
    let $logout             := session:invalidate()
    return
        <user>
            <username>{data($user)}</username>
            <groups></groups>
            <password></password>
            <logged-in>false</logged-in>
        </user>
)

