xquery version "3.1";
(:
    ART-DECOR® STANDARD COPYRIGHT AND LICENSE NOTE
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools GmbH
    see https://docs.art-decor.org/copyright and https://docs.art-decor.org/licenses

    This file is part of the ART-DECOR® tools suite.
:)
import module namespace ada     = "http://art-decor.org/ns/ada-common" at "ada-common.xqm";

declare namespace expath        = "http://expath.org/ns/pkg";
declare namespace compression   = "http://exist-db.org/xquery/compression";

declare option exist:serialize "method=xml media-type=application/zip,application/octet-stream charset=utf-8";

(:which ada-data/projects/ account do we want to download?:)
let $app            := if (request:exists()) then request:get-parameter('app','') else ('demo1')

let $appdir         := replace(replace(ada:getUri($app, ()), '//', '/'), '/+$', '')
let $zipname        := $app || '.zip'

(:create response which contains zip:)
return
    response:stream-binary(
        compression:zip( xs:anyURI($appdir), true(), $appdir),
        'application/zip',
        $zipname
    )

(:return
    <x app="{$app}" appdir="{$appdir}" zipname="{$zipname}"/>:)