xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

(:
   Xquery for deleting template ref
   Input: post of template element:
   <template projectPrefix="demo1-" ref="2.16.840.1.113883.1.10.1234" name="x" displayName="y"/>
:)
import module namespace get             = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
import module namespace art             = "http://art-decor.org/ns/art" at "art-decor.xqm";
import module namespace decor           = "http://art-decor.org/ns/decor" at "../api/api-decor.xqm";

let $projectPrefix      := request:get-parameter('prefix','')
let $ref                := request:get-parameter('ref','')

(:get decor file:)
let $decor                  := if (string-length($projectPrefix)=0) then () else (art:getDecorByPrefix($projectPrefix))
let $templateRef            := $decor//template[@ref = $ref]
(: get templateAssociations without concepts for this ref :)
let $templateAssociations   := art:getTemplateAssociationsP($decor, $ref, ())[not(concept)]

let $response           :=
    if ($decor and decor:authorCanEditP($decor, $decor:SECTION-RULES)) then (
        update delete $templateRef,
        update delete $templateAssociations,
        <response>OK</response>
    ) else (
        <response>NO PERMISSION</response>
    )
   
return
    $response