xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get             = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
import module namespace decor           = "http://art-decor.org/ns/decor" at "../api/api-decor.xqm";

let $templateName   := request:get-parameter('template','')
let $effectiveDate  := request:get-parameter('effectiveDate','')
(:let $templateName :='bloedgroep'
let $effectiveDate :='2013-01-30T16:27:09' :)

let $template               := $get:colDecorData//template[@name=$templateName][@effectiveDate=$effectiveDate][@statusCode='new']
let $templateAssociations   := if ($template) then $get:colDecorData//templateAssociation[@templateId=$template/@id][@effectiveDate=$effectiveDate] else ()
let $decor                  := $template/ancestor::decor

let $response           :=
    if (decor:authorCanEditP($decor, $decor:SECTION-RULES)) then (
        update delete $templateAssociations,
        update delete $template,
        <response>OK</response>
    ) else (
        <response>NO PERMISSION</response>
    )
   
return
    $response