xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

import module namespace art ="http://art-decor.org/ns/art" at "art-decor.xqm";
import module namespace get ="http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";

let $prefix         := if (request:exists()) then request:get-parameter('prefix', ())[not(. = '')] else ('kz-')
let $projectId      := if (request:exists()) then request:get-parameter('id', ())[not(. = '')] else ()

let $decor          :=
    if (not(empty($prefix))) then 
        art:getDecorByPrefix($prefix) 
    else
    if (not(empty($projectId))) then 
        art:getDecorById($projectId) 
    else ()
let $decorProject   := $decor/project

return
<communities>
{
    for $community in $get:colDecorData//community[@projectId = $decorProject/@id]
    order by lower-case(($community/@displayName, $community/@name)[1])
    return
    <community>
    {
        $community/@*,
        for $desc in $community/desc
        return
        art:serializeNode($desc)
    }
    </community>
}
</communities>
