xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

import module namespace get = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
import module namespace art = "http://art-decor.org/ns/art" at "art-decor.xqm";
declare namespace request   = "http://exist-db.org/xquery/request";
declare namespace response  = "http://exist-db.org/xquery/response";

let $projectPrefix          := if (request:exists()) then request:get-parameter('project','')[string-length()>0] else ()
let $projectVersion         := if (request:exists()) then request:get-parameter('version','')[string-length()>0] else ()
let $language               := if (request:exists()) then request:get-parameter('language','')[string-length()>0] else ()

(: if valued, will filter the scenario tree based on whether it references the requested dataset:)
let $datasetId              := if (request:exists()) then request:get-parameter('datasetId', ())[string-length()>0][not(.='*')] else ()
let $datasetEffectiveDate   := if (request:exists()) then request:get-parameter('datasetEffectiveDate', ())[string-length()>0][not(.='*')] else ()

(:let $projectPrefix  := 'demo1-':)

let $filteredScenarios      := 
    if (empty($datasetId))
    then art:getDecorByPrefix($projectPrefix, $projectVersion)//scenarios/scenario
    else art:getScenariosByDataset($datasetId, $datasetEffectiveDate)

return
<scenarios projectPrefix="{$projectPrefix}">
{
    for $scenario in $filteredScenarios
    order by $scenario/name[1]/lower-case(text()[1])
    return
        art:scenarioTree($scenario, $language, $datasetId, $datasetEffectiveDate)
}
</scenarios>
