xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

import module namespace get     = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
import module namespace art     = "http://art-decor.org/ns/art" at "art-decor.xqm";
import module namespace templ   = "http://art-decor.org/ns/decor/template" at "../api/api-decor-template.xqm";

let $project                := if (request:exists()) then request:get-parameter('project',()) else ('demo1-')
let $version                := if (request:exists()) then request:get-parameter('version',()) else ()
let $classified             := if (request:exists()) then request:get-parameter('classified',()) else ()
let $templateId             := if (request:exists()) then request:get-parameter('id',()) else ('2.16.840.1.113883.3.1937.99.62.3.10.4')
let $templateEffectiveDate  := if (request:exists()) then request:get-parameter('effectiveDate',()) else ('2009-10-01T00:00:00')
let $treetype               := if (request:exists()) then request:get-parameter('treetype',()) else ($templ:TREETYPEMARKED)

return
    templ:getTemplateList($templateId,(),$templateEffectiveDate,$project,$version,$classified='true',$treetype)