xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

import module namespace art     = "http://art-decor.org/ns/art" at "art-decor.xqm";
import module namespace get     = "http://art-decor.org/ns/art-decor-settings" at "xmldb:exist:///db/apps/art/modules/art-decor-settings.xqm";

let $project        := if (request:exists()) then request:get-parameter('project',()) else ('peri20-')
(: 
    all     = all transactions
    ds      = only transactions that have a representingTemplate/@sourceDataset
    tm      = only transactions that have a representingTemplate/@ref
    group   = only transactions of type group (transactions that group other transactions)
    item    = only transactions of type item (transactions that are stationary, initial or back)
:)
let $type           := if (request:exists()) then request:get-parameter('type','all') else ('ds')

return
    art:getScenarioList($project, (), (), $type)