xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

(:
   Xquery for setting template id
   Input: post of id-management instance
   <id-management old="" new="" effectiveDate=""/>
:)
import module namespace get             = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
import module namespace art             = "http://art-decor.org/ns/art" at "art-decor.xqm";
import module namespace decor           = "http://art-decor.org/ns/decor" at "../api/api-decor.xqm";

let $idm        := request:get-data()/id-management
let $template   := $get:colDecorData//template[@id=$idm/old][@effectiveDate=$idm/effectiveDate]
let $lock       := decor:getLocks($template/lock/@ref, $template/lock/@effectiveDate, (), false())

(:get decor file for permission check:)
let $decor      := $get:colDecorData//template[@id=$idm/old][@effectiveDate=$idm/effectiveDate]/ancestor::decor

let $idUpdate :=
    if (decor:authorCanEditP($decor, $decor:SECTION-RULES)) then (
        if ($lock) then
            <response>{$lock/node()}</response>
        else (
            let $storedTemplateAssociation  := $get:colDecorData//templateAssociation[@templateId=$idm/old][@effectiveDate=$idm/effectiveDate]
            let $storedTemplate             := $get:colDecorData//template[@id=$idm/old][@effectiveDate=$idm/effectiveDate]
            let $update                     := update value $storedTemplateAssociation/@templateId with $idm/new/text()
            let $update                     := update value $storedTemplate/@id with $idm/new/text()
            
            return <response>OK</response>
        )
    )
    else (
        <response>NO PERMISSION</response>
    )

return
    $idUpdate