xquery version "3.0";
(:
:   Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
:   see https://art-decor.org/mediawiki/index.php?title=Copyright
:   
:   This program is free software; you can redistribute it and/or modify it under the terms of the
:   GNU Lesser General Public License as published by the Free Software Foundation; either version
:   2.1 of the License, or (at your option) any later version.
:   
:   This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
:   without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
:   See the GNU Lesser General Public License for more details.
:   
:   The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:
:)
import module namespace get         = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";

declare %private function local:check-xqueries($path as xs:string) as element()* {
    for $xq in xmldb:get-child-resources($path)
    return 
        if (ends-with($xq, '.xquery') or ends-with($xq, '.xq') or ends-with($xq, '.xqm'))
        then 
            let $xq := concat($path, '/', $xq)
            let $chk := util:compile-query(util:binary-to-string(util:binary-doc($xq)), $path)
            return <checked xquery="{$xq}">{$chk}</checked>
        else ()
};

declare %private function local:traverse($path as xs:string) as element()* {
    for $coll in xmldb:get-child-collections($path)
    return 
        if ($coll='modules' or $coll='api') 
        then local:check-xqueries(concat($path, '/', $coll)) 
        else local:traverse(concat($path, '/', $coll))
};

(: default of 'empty' does all :)
let $packages       := if (request:exists()) then (request:get-parameter('pkg','')) else (('ada', 'art', 'decor/services', 'fhir', 'terminology', 'tools/oids'))

let $result         := 
    if (sm:is-dba(get:strCurrentUserName())) then (
        let $results    := 
            for $pkg in $packages
            (: do some input cleansing. no ../ constructs :)
            let $path   := string-join(('xmldb:exist:///db/apps',replace($pkg, '^\.+/*','')),'/')
            return
                if (xmldb:collection-available($path)) then local:traverse($path) else ()
        
        return
        <result failed="{count($results//info[@result='fail'])}" passed="{count($results//info[@result='pass'])}">
        {
            for $res in $results
            (: this puts fail before pass, but without second "order by" things would go random within first group :)
            order by $res/*/@result, $res/lower-case(@xquery)
            return
                $res
        }
        </result>
    ) 
    else (
        <result>NO PERMISSION</result>
    )

return 
    $result