xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace hist     = "http://art-decor.org/ns/decor/history" at "../api/api-decor-history.xqm";

declare %private function local:reindexHistory() {
(: 2.2-LTS or 4.0.0 and up :)
let $system-version     := tokenize(system:get-version(), '\.')[1]
(: new range appears stable from version 4 and up:)
let $use-new-range      := if ($system-version castable as xs:integer) then xs:integer($system-version) ge 4 else false()

let $decorHistoryConf   := if ($use-new-range) then local:getDecorHistoryIndexV4() else local:getDecorHistoryIndexV2()
let $update             := xmldb:create-collection(concat('/db/system/config', repo:get-root()), 'decor/history')
let $update             := xmldb:store($update, 'collection.xconf', $decorHistoryConf)
let $update             := xmldb:reindex(xmldb:create-collection(repo:get-root(), 'decor/history'))

return ()
};
(: keep in sync with art/pre-install.xql :)
declare %private function local:getDecorHistoryIndexV2() as element() {
<collection xmlns="http://exist-db.org/collection-config/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema">
    <!-- decor/history index definition for eXist 2.2 -->
    <index>
        <fulltext default="none" attributes="false"/>
        <create qname="@artefactType" type="xs:string"/>
        <create qname="@projectPrefix" type="xs:string"/>
        <create qname="@artefactId" type="xs:string"/>
        <create qname="@artefactEffectiveDate" type="xs:string"/>
        <create qname="@date" type="xs:string"/>
    </index>
</collection>
};
declare %private function local:getDecorHistoryIndexV4() as element() {
<collection xmlns="http://exist-db.org/collection-config/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema">
    <!-- decor/history index definition for eXist 4.3.1 and up -->
    <index>
        <fulltext default="none" attributes="false"/>
        <range>
            <create qname="@artefactType" type="xs:string"/>
            <create qname="@projectPrefix" type="xs:string"/>
            <create qname="@artefactId" type="xs:string"/>
            <create qname="@artefactEffectiveDate" type="xs:string"/>
            <create qname="@date" type="xs:string"/>
        </range>
    </index>
</collection>
};

let $statusonly         := if (request:exists()) then request:get-parameter('statusonly', 'true')='true' else (true())

let $update             := hist:ConvertHistory($statusonly)
let $updateHistoryIndex := if ($statusonly) then () else local:reindexHistory()

return
    <result dateTime="{current-dateTime()}" statusOnly="{$statusonly}">{$update}</result>