xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace ada     = "http://art-decor.org/ns/ada-common" at "../../ada/modules/ada-common.xqm";
import module namespace adaxml  = "http://art-decor.org/ns/ada-xml" at "../../ada/modules/ada-xml.xqm";
import module namespace art     = "http://art-decor.org/ns/art" at "art-decor.xqm";

let $projectPrefix  := if (request:exists()) then request:get-parameter('prefix',())[1] else ('demo1-')
let $decor          := if (empty($projectPrefix)) then () else art:getDecorByPrefix($projectPrefix)
let $language       := if (request:exists()) then request:get-parameter('language', $decor/project/@defaultLanguage)[1] else ($decor/project/@defaultLanguage)[1]

let $ada-apps       := if ($decor) then ada:getApplications((), $language) else ()

let $ada-apps       :=
    for $ada-app in $ada-apps
    return
        if ($decor//transaction[@id = $ada-app/view/@transactionId]) then ( $ada-app ) else ()

return
    <return>
    {
        $ada-apps
    }
    </return>
