xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get         = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
declare namespace sm                = "http://exist-db.org/xquery/securitymanager";

let $user       := if (request:exists()) then request:get-parameter('username',()) else ()
let $groups     := if (string-length($user) = 0) then sm:list-groups() else (sm:get-user-groups($user))

let $user       := 
    if (get:strCurrentUserName() = ('guest','')) then 'guest' else 
    if (string-length($user) gt 0) then $user else (get:strCurrentUserName())

return
<groups user="{$user}">
{
    for $group at $i in $groups
    let $userExists := try { sm:user-exists($group) } catch * {false()}
    order by lower-case($group)
    return
        <group navkey="{$i}">
        {
            if ($userExists) then attribute userGroup {'true'} else (),
            $group
        }
        </group>
}
</groups>
