xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

import module namespace get     = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
declare namespace xhtml         = "http://www.w3.org/1999/xhtml";
declare namespace xsl           = "http://www.w3.org/1999/XSL/Transform";

let $packageRoot    := if (request:exists()) then request:get-parameter('packageRoot','art') else 'art'
let $resource       := if (request:exists()) then request:get-parameter('resource',()) else ()
let $forms          := 
    collection(concat($get:root,$packageRoot,'/xforms'))/xhtml:html | 
    collection(concat($get:root,$packageRoot,'/resources/stylesheets'))/xsl:stylesheet

let $fullPath       := concat('$resources/',$resource)

return
<usage>
{
    if (empty($resource)) then () else (
        for $form in $forms
        let $count  := count( 
            $form//@ref[contains(., $fullPath)] | 
            $form//@title[contains(., $fullPath)] |  
            $form//@value[contains(., $fullPath)] | 
            $form//xsl:attribute[contains(., $fullPath)] 
        )
        return
            if ($count gt 0) then 
                <xform name="{util:document-name($form)}" count="{$count}"/>
            else ()
        ,
        if ($packageRoot = 'art') then (
            for $form in collection(concat($get:root,$packageRoot,'/resources'))/menu
            let $count  := count( $form//@label[. = $resource] )
            return
                if ($count gt 0) then 
                    <xform name="{util:document-name($form)}" count="{$count}"/>
                else ()
        ) else ()
    )
}
</usage>


