xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get = "http://art-decor.org/ns/art-decor-settings" at "xmldb:exist:///db/apps/art/modules/art-decor-settings.xqm";
(:import module namespace get ="http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";:)
(:import module namespace get ="http://art-decor.org/ns/art-decor-settings" at "../../../modules/art-decor-settings.xqm";:)
declare namespace expath    = "http://expath.org/ns/pkg";

declare %private function local:cleanupTerminologyName($s as xs:string?) as xs:string? {
    if (empty($s)) then () else (
        replace(replace($s,'\s*[Tt]erminology\s*[Ds]ata\s*-\s*',''),' [Dd]ata$','')
    )
};

(: all terminology data collections :)
let $newTerminologyCollections :=('codesystem-stable-data','codesystem-authoring-data','conceptmap-authoring-data','conceptmap-stable-data','valueset-authoring-data','valueset-stable-data','nictiz-demo-data')
let $collections        := if (xmldb:collection-available($get:strTerminologyData)) then xmldb:get-child-collections($get:strTerminologyData) else ()
let $classifications    :=
    <classifications>
    {
        for $child in $collections[not(.=$newTerminologyCollections)]
        let $colName        := concat($get:strTerminologyData,'/',$child)
        let $titles         := collection($colName)//ClaML/Title
        let $packageTitle   := local:cleanupTerminologyName(collection($colName)//expath:package/expath:title/text())
        order by lower-case($packageTitle)
        return
        if ($titles) then
            <classification collection="{$child}" displayName="{$packageTitle}">
            {
                for $title in $titles
                return
                <Title language="{substring-after(substring-before(util:collection-name($title),'/claml'),concat($get:strTerminologyData,'/',$child,'/'))}">
                {
                    $title/@*,
                    $title/text()
                }
                </Title>
            }
            </classification>
        else()
    }
    </classifications>
    
    let $packages :=
    <packages>
    {
        for $child in $collections[not(.=$newTerminologyCollections)]
        let $package    := collection(concat($get:strTerminologyData,'/',$child))//expath:package
        let $abbrev     := $package/@abbrev
        let $version    := $package/@version
        let $name       := local:cleanupTerminologyName($package/expath:title/text())
        order by $name
        return
            if (empty($package)) then () else (
                <package abbrev="{$abbrev}" version="{$version}">{$name}</package>
            )
    }
    </packages>

return
<terminology>
    {$classifications,$packages}
</terminology>