xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace art             = "http://art-decor.org/ns/art" at "art-decor.xqm";
declare namespace request               = "http://exist-db.org/xquery/request";

(: Add resources to form-resources, package root is in requestData/@packageRoot:)
let $requestData            := if (request:exists()) then request:get-data()/artXformResources else ()
let $packageRoot            := if (request:exists()) then request:get-parameter('packageRoot',()) else ()
(:  Include updating the ART menu if applicable :)
let $doArtMenuUpdate        := true()

let $update                 := 
    if (empty($packageRoot)) then ()
    else
        art:saveFormResources($packageRoot, $requestData, $doArtMenuUpdate)

return
    <response status="saved"/>
