xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

import module namespace get = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
import module namespace art = "http://art-decor.org/ns/art" at "art-decor.xqm";

declare %private function local:preparePrototype($prototype as element()) as element() {
    <prototype>
    {
        $prototype/@ref[not(. = '')]
        ,
        for $data in $prototype/data
        return
            <data>
            {
                $data/@*,
                for $desc in $data/desc
                return
                    art:parseNode($desc)
            }
            </data>
    }
    </prototype>
};

(: get community from request :)
let $newCommunity := request:get-data()/community

(: get project parent collection  :)
let $parentCollection := util:collection-name($get:colDecorData//decor[project/@id = $newCommunity/@projectId])

let $community :=
    <community>
    {
        $newCommunity/@name,
        $newCommunity/@projectId,
        if (string-length($newCommunity/@displayName) = 0) then
            attribute displayName {$newCommunity/@name}
        else
            ($newCommunity/@displayName),
        for $desc in $newCommunity/desc
        return
            art:parseNode($desc)
        ,
        $newCommunity/access
        ,
        local:preparePrototype($newCommunity/prototype)
    }
    </community>


return
    <result>
        {xmldb:store($parentCollection, concat('community-', $newCommunity/@name, '.xml'), $community)}
    </result>