xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

import module namespace vs  = "http://art-decor.org/ns/decor/valueset" at "../api/api-decor-valueset.xqm";

let $references         := if (request:exists()) then request:get-data()/* else ()
(:let $references         := 
        <associations>
            <association conceptId="..." effectiveDate="..." valueSet="2.16.840.1.113883.3.1937.99.62.3.11.7" flexibility="2014-12-10T00:00:00"/>
        </associations>:)
let $projectPrefix      := if (request:exists()) then request:get-parameter('project',())[string-length()>0][1] else ('demo1-')
let $projectVersion   := if (request:exists()) then request:get-parameter('version',())[string-length()>0][1] else ()
let $projectLanguage  := if (request:exists()) then request:get-parameter('language',())[string-length()>0][1] else ()
let $serialize        := if (request:exists()) then not(request:get-parameter('serialize', 'true')[string-length()>0][1] = 'false') else true()

return
<valueSets>
{
    for $reference in $references/*[string-length(@valueSet)>0]
    let $ref        := $reference/@valueSet
    let $eff        := if ($reference/@flexibility[string-length()>0]) then $reference/@flexibility else ('dynamic')
    let $valueSets  := vs:getExpandedValueSetByRef($ref, $eff, $projectPrefix, $projectVersion, $projectLanguage, $serialize)
    return
        for $valueSet in $valueSets/descendant-or-self::valueSet
        order by xs:dateTime($valueSet/@effectiveDate) descending
        return
            <valueSet>
            {
                $valueSet/(@* except @conceptId),
                attribute conceptId {$reference/@conceptId},
                if (not($valueSet/@url)) then $valueSet/parent::*/@url else (),
                if (not($valueSet/@ident)) then $valueSet/parent::*/@ident else (),
                $valueSet/node()
            }
            </valueSet>
}
</valueSets>