xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.
    
    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get    = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
import module namespace aduser = "http://art-decor.org/ns/art-decor-users" at "../api/api-user-settings.xqm";

declare namespace sm  = "http://exist-db.org/xquery/securitymanager";
declare namespace xis = "http://art-decor.org/ns/xis";

let $accounts           := doc($get:strTestAccounts)/xis:testAccounts
(: create collections and groups if needed :)
let $groups :=
    for $account in $accounts/xis:testAccount[string-length(@name) gt 0]
    let $accountName    := $account/@name/string()
    let $accountMembers := if (sm:group-exists($accountName)) then sm:get-group-members($accountName) else ()
    let $memberList     :=
        <members xmlns="http://art-decor.org/ns/xis">
        {
            for $member in $accountMembers
            let $memberName := aduser:getUserDisplayName($member)
            order by $member
            return
                <user id="{$member}">{if (empty($memberName)) then $member else ($memberName)}</user>
        }
        </members>
    return
        if (sm:group-exists($accountName)) then 
            update replace $account/xis:members with $memberList
        else ()
        
return
    <data-safe>true</data-safe>
