xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

(:
   Query for retrieving decor locks
:)
import module namespace get             = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
import module namespace decor           = "http://art-decor.org/ns/decor" at "../api/api-decor.xqm";

let $id                     := if (request:exists()) then request:get-parameter('id',(),true())[string-length()>0] else ()
let $effectiveDate          := if (request:exists()) then request:get-parameter('effectiveDate',())[string-length()>0] else ()
let $breakLock              := if (request:exists()) then request:get-parameter('breakLock',())[string-length()>0] else ()

let $username               := get:strCurrentUserName()

return
    decor:setLock($id, $effectiveDate, $breakLock)
