xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

(:
   Xquery for inserting valueSet ref into terminology
   Input: post of ref element:
   <valueSet projectPrefix="demo1-" ref="ref-oid" name="x" displayName="y"/>
:)
import module namespace get             = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
import module namespace art             = "http://art-decor.org/ns/art" at "art-decor.xqm";
import module namespace decor           = "http://art-decor.org/ns/decor" at "../api/api-decor.xqm";

let $objref         := if (request:exists()) then request:get-data()/valueSet else ()
let $projectPrefix  := $objref/@projectPrefix

(:get decor file:)
let $decor          := art:getDecorByPrefix($projectPrefix)

(: get user for permission check:)
let $user           := get:strCurrentUserName()

let $alreadyrefed   := $decor/terminology/valueSet[@ref = $objref/@ref]
let $refsbyname     := 
    if ($alreadyrefed) then (
        $decor/terminology/terminologyAssociation[@valueSet = $alreadyrefed/@name] |
        $decor/terminology/valueSet/include[@ref = $alreadyrefed/@name] | 
        $decor/rules//vocabulary[@valueSet = $alreadyrefed/@name]
    )
    else ()
let $ref            :=
    if ($objref[@ref[string-length() > 0]][@name[string-length() > 0]]) then 
        element {$objref/name()} {
            $objref/@ref, 
            (: prevent broken, old-style links if any :)
            if (exists($refsbyname)) then $alreadyrefed/@name else $objref/@name
            ,
            if ($objref/@displayName[string-length() > 0]) then 
                $objref/@displayName
            else (
                attribute displayName {$objref/@name}
            )
        }
    else ()
    

return
    if ($decor) then (
        if (decor:authorCanEditP($decor, $user, $decor:SECTION-TERMINOLOGY)) then (
            if ($ref) then (
                if ($alreadyrefed) then (
                    (: this allows us to change the displayName while not breaking the reference :)
                    let $u1 :=
                        update replace $alreadyrefed/@displayName with $ref/@displayName
                    
                    return
                    <response>{$ref/@*,'OK'}</response>
                )
                else (
                    let $u1 :=
                        if ($decor/terminology) then () else (
                            update insert <terminology/> following $decor/ids
                        )
                    let $u2 := update insert $ref into $decor/terminology
                    
                    return
                    <response>{$ref/@*,'OK'}</response>
                )
            )
            else (
                <response>MISSING @ref and/or @name</response>
            )
        )
        else (
            <response>NO PERMISSION</response>
        )
    )
    else (
        <response>PROJECT {$projectPrefix} NOT FOUND</response>
    )