xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
import module namespace vs  = "http://art-decor.org/ns/decor/valueset"     at "../api/api-decor-valueset.xqm";
import module namespace cs  = "http://art-decor.org/ns/decor/codesystem"   at "../api/api-decor-codesystem.xqm";
declare namespace xs        = "http://www.w3.org/2001/XMLSchema";
declare namespace xforms    = "http://www.w3.org/2002/xforms";

declare namespace json                  =  "http://www.json.org";
declare namespace output                = "http://www.w3.org/2010/xslt-xquery-serialization";

declare option    output:method "json";
declare option    output:media-type "application/json";
declare option    exist:serialize "json-ignore-whitespace-text-nodes=yes";

let $projectPrefix          := if (request:exists()) then request:get-parameter('project',()) else ()
let $version                := if (request:exists()) then request:get-parameter('version',()) else ()
let $id                     := if (request:exists()) then request:get-parameter('id',()) else ()
let $name                   := if (request:exists()) then request:get-parameter('name',()) else ()
let $flexibility            := if (request:exists()) then request:get-parameter('flexibility',()) else ()
(:let $project              := 'peri20-':)
let $treetype               := if (request:exists()) then request:get-parameter('treetype',$vs:TREETYPELIMITEDMARKED) else ($vs:TREETYPEMARKED)
let $withversions           := if (request:exists()) then request:get-parameter('withversions','true')='true' else (true())
let $doV2                   := if (request:exists()) then request:get-parameter('v2','false')='true' else ()

let $valueSets              := 
    if ($doV2) then
        vs:getValueSetList-v2($id, $name, $flexibility, $projectPrefix, $version, $withversions, $treetype)
    else
        vs:getValueSetList($id, $name, $flexibility, $projectPrefix, $version)
let $decorProjectValuesets  := $valueSets/project

let $codeSystems            :=
        cs:getCodeSystemList ($id, $name, $flexibility, $projectPrefix)

return
    if ($doV2) then
        $valueSets
    else
    if ($withversions) then
        <valueSetList>
        {
            for $valueSet in $decorProjectValuesets/valueSet
            let $id := $valueSet/@id | $valueSet/@ref
            group by $id
            return
            <valueSet json:array="true">
            {
                $valueSet[1]/@id | $valueSet[1]/@ref
            }
            {
                for $v in $decorProjectValuesets/valueSet[(@id|@ref)=$id]
                order by $v/@effectiveDate descending
                return
                    $v
            }
            </valueSet>
            ,
            $codeSystems
        }
        </valueSetList>
    else
        <valueSetList>
        {
            let $valueSetList       :=
                for $valueSetsById in $decorProjectValuesets/valueSet
                let $id             := $valueSetsById/@id | $valueSetsById/@ref
                group by $id
                return
                    <valueSet uuid="{util:uuid()}" json:array="true">
                    {
                        let $latestVersion  := string(max($valueSetsById/xs:dateTime(@effectiveDate)))
                        let $latestValueSet := if ($latestVersion) then ($valueSetsById[@effectiveDate=$latestVersion][1]) else $valueSetsById[1]
                        
                        return
                        $latestValueSet/@*
                    }
                    </valueSet>
            
            for $valueSet in $valueSetList
            order by $valueSet/lower-case(@displayName)
            return
                $valueSet
            ,
            $codeSystems
        }
        </valueSetList>
