xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

(:
   Query for deleting lock entries AND deleting newly created concepts
   Input:
   edited dataset 
   Return:
   data-safe=true
:)
import module namespace decor           = "http://art-decor.org/ns/decor" at "../api/api-decor.xqm";
import module namespace get             = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";

let $dataset        := if (request:exists()) then request:get-data()/dataset else ()

let $clear          := 
    for $lock in $dataset//lock[@type=($decor:OBJECTTYPE-DATASET,$decor:OBJECTTYPE-DATASETCONCEPT)]
    let $ref            := $lock/@ref
    let $effectiveDate  := $lock/@effectiveDate
    let $projectId      := ()
    return
        decor:deleteLock($ref, $effectiveDate, $projectId)

let $deletes    :=
    for $concept in $dataset//concept[@statusCode='new'][not(ancestor::history)]
    return
        update delete $get:colDecorData//concept[@id=$concept/@id][@effectiveDate=$concept/@effectiveDate][not(ancestor::history)]

return
    <data-safe>true</data-safe>

