xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

import module namespace art ="http://art-decor.org/ns/art" at "art-decor.xqm";
declare namespace request = "http://exist-db.org/xquery/request";

let $conceptId                  := if (request:exists()) then request:get-parameter('id',())[not(.='')]                       else ('2.16.840.1.113883.3.1937.99.62.3.2.18')
let $conceptEffectiveDate       := if (request:exists()) then request:get-parameter('effectiveDate',())[not(.='')]            else ('2011-01-28T00:00:00')
let $transactionId              := if (request:exists()) then request:get-parameter('transactionId',())[not(.='')]            else ('2.16.840.1.113883.3.1937.99.62.3.4.2')
let $transactionEffectiveDate   := if (request:exists()) then request:get-parameter('transactionEffectiveDate',())[not(.='')] else ('2012-09-05T16:59:35')
(:relevant only for transactions. If all you care about is the final tree without any absent concepts: set this parameter to false:)
let $fullTree                   := if (request:exists()) then request:get-parameter('fullTree','true')[not(.='')] else ('false')

return art:getConceptTree($conceptId, $conceptEffectiveDate, $transactionId, $transactionEffectiveDate, $fullTree='true')