xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)

import module namespace art ="http://art-decor.org/ns/art" at "art-decor.xqm";
declare namespace request = "http://exist-db.org/xquery/request";

let $datasetId                  := if (request:exists()) then request:get-parameter('id',())[not(.='')]                       else ()
let $datasetEffectiveDate       := if (request:exists()) then request:get-parameter('effectiveDate',())[not(.='')]            else ()
let $transactionId              := if (request:exists()) then request:get-parameter('transactionId',())[not(.='')]            else ()
let $transactionEffectiveDate   := if (request:exists()) then request:get-parameter('transactionEffectiveDate',())[not(.='')] else ()
(:relevant only for transactions. If all you care about is the final tree without any absent concepts: set this parameter to false:)
let $fullTree                   := if (request:exists()) then request:get-parameter('fullTree','true')[not(.='')] else ()

return art:getDatasetTree($datasetId, $datasetEffectiveDate, $transactionId, $transactionEffectiveDate, $fullTree='true')