xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright
    
    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace hist     = "http://art-decor.org/ns/decor/history" at "../api/api-decor-history.xqm";

declare namespace request        = "http://exist-db.org/xquery/request";

let $artefact       := if (request:exists()) then (request:get-parameter('artefact','')) else ()
let $prefix         := if (request:exists()) then (request:get-parameter('prefix',())) else ()
let $id             := if (request:exists()) then (request:get-parameter('id','')) else ()
let $effectiveDate  := if (request:exists()) then (request:get-parameter('effectiveDate','')) else ()

return
    if (string-length($artefact) gt 0 and string-length($prefix) gt 0)
    then hist:ListHistory($artefact, $prefix, $id, $effectiveDate)
    else (
        <histories>
        {
            if (empty($artefact)) then () else attribute artefactType {$artefact},
            if (empty($prefix)) then () else attribute projectPrefix {$prefix},
            if (empty($id)) then () else attribute id {$id},
            if (empty($effectiveDate)) then () else attribute effectiveDate {$effectiveDate}
        }
        </histories>
    )