xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get     = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";

declare namespace expath    = "http://expath.org/ns/pkg";

let $allPackages := collection($get:root)/expath:package
return
<packages>
{
    for $package in $allPackages
    let $parentCollection := substring-after(util:collection-name($package),$get:root)
    order by lower-case($parentCollection)
    return
    <package title="{$package//expath:title}" collection="{$parentCollection}">
    {
        $package/@version | $package/@abbrev
    }
    </package>
}
</packages>