xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get     = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
import module namespace art     = "http://art-decor.org/ns/art" at "art-decor.xqm";
declare namespace xforms        = "http://www.w3.org/2002/xforms";
declare namespace xhtml         = "http://www.w3.org/1999/xhtml";
declare namespace xsl           = "http://www.w3.org/1999/XSL/Transform";

let $packageRoot        := if (request:exists()) then request:get-parameter('packageRoot','art') else 'art'
let $artXformResources  := art:getFormResources($packageRoot)
let $resources          := $artXformResources/resources[1]
let $forms              :=  collection(concat($get:root,$packageRoot,'/xforms'))/xhtml:html | 
                            collection(concat($get:root,$packageRoot,'/resources/stylesheets'))/xsl:stylesheet |
                            collection(concat($get:strArtData,'/resources'))//menu
                            
let $results        := 
    for $resource in $resources/*/name()
    let $fullPath       := concat('$resources/',$resource)
    let $matches        :=
            $forms//*[contains(@ref,$fullPath)] |
            $forms//*[contains(@value,$fullPath)] |
            $forms//xsl:attribute[contains(.,$fullPath)] |
            $forms//*[@label=$resource]
    return
        if (empty($matches)) then (
            <resource>{$resource}</resource>
        ) else ()
return
<unused unused="{count($results)}" total="{count($resources/*)}">
{
    $results
}
</unused>