xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get             = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
import module namespace art             = "http://art-decor.org/ns/art" at "art-decor.xqm";
import module namespace decor           = "http://art-decor.org/ns/decor" at "../api/api-decor.xqm";

(: get dataset from request :)
let $codeSystems        := if (request:exists()) then (request:get-data()/codeSystems) else ()
let $decor              := if (empty($codeSystems/@projectPrefix)) then () else art:getDecorByPrefix($codeSystems/@projectPrefix)
let $projectPrefix      := $decor/project/@prefix
let $canEdit            := if (empty($projectPrefix)) then (false()) else decor:authorCanEditP($decor, $decor:SECTION-TERMINOLOGY)

let $store              :=
    if ($canEdit) then
        for $codeSystem in $codeSystems/codeSystem
        let $storedCodeSystem := $decor/terminology/codeSystem[@ref=$codeSystem/@ref]
        return
            if ($storedCodeSystem) then
                if ($codeSystem[@action = 'delete']) then
                    update delete $storedCodeSystem
                else
                    update replace $storedCodeSystem with $codeSystem
            else if (not($storedCodeSystem) and $decor/terminology/valueSet) then
                update insert $codeSystem preceding $decor/terminology/valueSet[1]
            else (
                update insert $codeSystem into $decor/terminology
            )
    else ()

return
<data-safe>{$canEdit}</data-safe>
