xquery version "1.0";
(:
:   Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
:   see https://art-decor.org/mediawiki/index.php?title=Copyright
:   
:   This program is free software; you can redistribute it and/or modify it under the terms of the
:   GNU Lesser General Public License as published by the Free Software Foundation; either version
:   2.1 of the License, or (at your option) any later version.
:   
:   This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
:   without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
:   See the GNU Lesser General Public License for more details.
:   
:   The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace gg          = "http://art-decor.org/ns/decor/governancegroups" at "../api/api-decor-governancegroups.xqm";
declare namespace request           = "http://exist-db.org/xquery/request";

(:
Expected structure in request: request:get-data()//group[string-length(@id)>0]
This xquery saves either

A)
the governance group link to be established for the project in the project collection named
governance-group-links.xml as requested
If file governance-group-links.xml does not exist a new one is created

<governance-group-links projectId="...">
  <partOf governanceId="..."/>
</governance-group-links>

B)
or all (updated) governance group definitions, wrapped by some element, to add/update content of file art-data / hosted-governance-groups.xml.
Deletion currently not supported. If file hosted-governance-groups.xml does not exist a new one is created

<result>
  <group id="..." defaultLanguage="...">
  ...
  </group>
  <group id="..." defaultLanguage="...">
  ...
  </group>
</result>

:)

let $groups     := if (request:exists()) then request:get-data()//group else ()
let $groups     := $groups[string-length(@id)>0]
let $action     := $groups/@action
    
let $res        :=
    (: ------------ save link to governance group for a specific project ------------ :)
    if ($action=('link','unlink')) then (
        gg:saveGroupLinks($groups)
    )
    (: ------------ save governance all group definitions for this server ------------ :)
    else (
        gg:saveGroups($groups)
    )
    
return ()
