xquery version "3.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace get     = "http://art-decor.org/ns/art-decor-settings" at "art-decor-settings.xqm";
import module namespace art     = "http://art-decor.org/ns/art" at "art-decor.xqm";

declare option exist:serialize "indent=yes";
declare option exist:serialize "omit-xml-declaration=no";

let $projectPrefix  := if (request:exists()) then request:get-parameter('project','') else ('demo1-')
let $checks         := if (request:exists()) then request:get-parameter('checks','') else ('aa bb unibid')
let $checkFile      := concat($projectPrefix, 'check-config.xml')
(: 
If there is $get:strDecorVersion and no [project]/development, create it 
This code can be removed if release/[project]/development once is created on project creation
:)
let $make           :=  if (not(xmldb:collection-available(get:strProjectDevelopment($projectPrefix))) and xmldb:collection-available($get:strDecorVersion)) 
                        then art:mkcol($get:strDecorVersion, replace(get:strProjectDevelopment($projectPrefix), $get:strDecorVersion, ''))
                        else ()
let $save           := try { xmldb:store(get:strProjectDevelopment($projectPrefix), $checkFile, <config optionalChecks="{$checks}"/>) } catch * {"NOTSAVED"}
let $save           := if ($save="NOTSAVED") then $save else try { sm:chmod(xs:anyURI($save), 'rw-rw-r--') } catch * {"NOTCHMODED"}

return ()