xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
import module namespace adsearch       = "http://art-decor.org/ns/decor/search" at "../api/api-decor-search.xqm";

let $searchTerms            := if (request:exists()) then tokenize(lower-case(request:get-parameter('searchString',())),'\s') else ()
let $projectPrefix          := if (request:exists()) then (request:get-parameter('project',())) else ()
let $datasetId              := if (request:exists()) then (request:get-parameter('datasetId',())) else ()
let $datasetEffectiveDate   := if (request:exists()) then (request:get-parameter('datasetEffectiveDate',())) else ()
let $conceptType            := if (request:exists()) then (request:get-parameter('type',())) else ()
let $statusCodes            := if (request:exists()) then (request:get-parameter('status',())) else ()
let $searchPrefix           := if (request:exists()) then (request:get-parameter('searchPrefix',())[string-length() gt 0]) else ()

(:mostly interesting when we're called from the similar concepts context in the dataset form when we're creating a new concept:)
(:we inherit only from original concepts:)
let $originalOnly           := if (request:exists()) then request:get-parameter('originalonly',()) else ()

(:we want to distinguish between local searches and searches that include the current project:)
let $localConceptsOnly      := if (request:exists()) then request:get-parameter('localConceptsOnly','true') else ('true')

let $maxResults             := if (request:exists()) then (request:get-parameter('max',())) else ()
let $maxResults             := 
    if ($maxResults castable as xs:integer and xs:integer($maxResults)>0) then (xs:integer($maxResults)) else 50

return
adsearch:searchConcept($projectPrefix, $searchTerms, $maxResults, (), (), $datasetId, $datasetEffectiveDate, $conceptType, $statusCodes, $originalOnly='true', $localConceptsOnly='true', $searchPrefix)