xquery version "3.1";
(:
    ART-DECOR® STANDARD COPYRIGHT AND LICENSE NOTE
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools GmbH
    see https://docs.art-decor.org/copyright and https://docs.art-decor.org/licenses

    This file is part of the ART-DECOR® tools suite.
:)

module namespace utilgg                 = "http://art-decor.org/ns/api/util-governancegroup";

import module namespace setlib          = "http://art-decor.org/ns/api/settings" at "settings-lib.xqm";

import module namespace errors          = "http://e-editiones.org/roaster/errors";

(: Returns any governance-group-links elements for a given groupId so we know what project claims to be partOf that governance group
<governance-group-links ref="2.16.840.1.113883.2.4.3.111.3.7">
    <partOf ref="2.16.840.1.113883.2.4.3.111"/>
</governance-group-links>:)
declare function utilgg:getLinkedProjects($groupId as xs:string) as element(governance-group-links)* {
    $setlib:colDecorData/governance-group-links[partOf/@ref = $groupId]
};