xquery version "3.1";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
module namespace permissionslib         = "http://art-decor.org/ns/api/permissions";
import module namespace setlib          = "http://art-decor.org/ns/api/settings" at "settings-lib.xqm";
import module namespace repo            = "http://exist-db.org/xquery/repo";

declare namespace sm            = "http://exist-db.org/xquery/securitymanager";
declare namespace util          = "http://exist-db.org/xquery/util";
declare namespace xforms        = "http://www.w3.org/2002/xforms";
declare namespace xxforms       = "http://orbeon.org/oxf/xml/xforms";
declare namespace xhtml         = "http://www.w3.org/1999/xhtml";

(:  Mode            Octal
 :  rw-r--r--   ==  0644
 :  rw-rw-r--   ==  0664
 :  rwxr-xr--   ==  0754
 :  rwxr-xr-x   ==  0755
 :  rwxrwxr-x   ==  0775
 :)

(:install path for art (normally /db/apps/), includes trailing slash :)
declare variable $permissionslib:root   := concat(repo:get-root(), 'api/');

(:~ Call to fix any potential permissions problems in the path /db/apps/api/modules
:   Dependency: $get:strArt, $get:strArtResources, $get:strArtData
:)
declare function permissionslib:setApiPermissions() {
    permissionslib:checkIfUserDba(),
    
    sm:chown(xs:anyURI(concat($permissionslib:root, 'modules')),'admin:decor'),
    sm:chmod(xs:anyURI(concat($permissionslib:root, 'modules')), 'rwxr-sr-x'),
    sm:clear-acl(xs:anyURI(concat($permissionslib:root, 'modules'))),
    
    permissionslib:setPermissions(concat($permissionslib:root, 'modules'), 'api-user', 'decor', 'rwxr-sr-x', 'api-user', 'decor', 'rwsr-sr-x'),
    
    for $adminapi in ('user-api.xqm', 'library/api-admin.xql', 'library/periodic-notifier.xql', 'library/scheduled-refreshs.xql', 'library/scheduled-notifier.xql')
    let $path   := concat($permissionslib:root, 'modules/', $adminapi)
    return (
        sm:chown(xs:anyURI($path), 'api-admin')
    ),
    
    for $res in xmldb:get-child-resources(xs:anyURI($permissionslib:root))
    return (
        (:sm:chown(xs:anyURI(concat($permissionslib:root,'/',$res)), 'admin:decor'),:)
        if ($res = 'api.html') then
            sm:chmod(xs:anyURI(concat($permissionslib:root,'/',$res)), 'rwxr-xr-x')
        else ()
    ),
    
    (: create to set a document /dp/secure/security.xml to settle some secutrity features and keys :)
    if (xmldb:collection-available($setlib:strSecureConfig)) then () else xmldb:create-collection('/db', substring-after($setlib:strSecureConfig, '/db/')),

    if (doc-available($setlib:strSecureConfig || '/security.xml')) then () else (
        xmldb:store($setlib:strSecureConfig, 'security.xml', document {
                comment { ' ART-DECOR security ' } |
                <authentication>
                    <!-- 
                        This resource supports ART-DECOR security aspects such as
                            - the ART-DECOR API login process based on JWT tokens
                            - ADBot token for automated processes
                    
                        Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
                        see https://docs.art-decor.org/copyright/
                    -->
                    <!-- 
                        This is this server's signature for cloud operations
                    -->
                    <server signature="---server-signature---"/>
                    <!-- 
                        token-lifetime: how long will the token be valid in seconds: 
                        - 30 minutes = 30*60 seconds = 1800 s
                        - 1 hour = 60*60 seconds = 3600 s
                        - 4 hours 4*60*60 seconds = 14440 s
                        - 8 hours = 8*60*60 = 28800 s
                    -->
                    <token-lifetime>28800</token-lifetime>
                    <!-- 
                        secret: used in token generation and validation, 
                        this should be unique on every server to avoid token reuse across servers.
                        
                        You may change this value to anything later on.
                        This renders tokens based on the previous value invalid.
                    -->
                    <secret>{util:uuid()}</secret>
                    <!--
                        ADBot token for automated processes
                    -->
                    <adbot username="adbot" token="---adbot-token---"/>
                </authentication>
            }
        )
    ),
    
    permissionslib:setPermissions($setlib:strSecureConfig, 'api-user', 'dba', 'r-xrws---', 'api-user', 'dba', 'r-srws---')
};

(:
:   Helper function with recursion for permissionslib:setDecorPermissions()
:)
declare function permissionslib:setPermissions($path as xs:string, $collusrown as xs:string?, $collgrpown as xs:string?, $collmode as xs:string, $resusrown as xs:string?, $resgrpown as xs:string?, $resmode as xs:string) {
    if (string-length($collusrown) = 0) then () else sm:chown(xs:anyURI($path),$collusrown),
    if (string-length($collgrpown) = 0) then () else sm:chgrp(xs:anyURI($path),$collgrpown),
    sm:chmod(xs:anyURI($path),$collmode),
    sm:clear-acl(xs:anyURI($path)),
    for $res in xmldb:get-child-resources(xs:anyURI($path))
    return (
        if (empty($resusrown)) then () else sm:chown(xs:anyURI(concat($path,'/',$res)),$resusrown),
        if (empty($resgrpown)) then () else sm:chgrp(xs:anyURI(concat($path,'/',$res)),$resgrpown),
        sm:chmod(xs:anyURI(concat($path,'/',$res)),$resmode),
        sm:clear-acl(xs:anyURI(concat($path,'/',$res)))
    )
    ,
    for $collection in xmldb:get-child-collections($path)
    return
        permissionslib:setPermissions(concat($path,'/',$collection), $collusrown, $collgrpown, $collmode, $resusrown, $resgrpown, $resmode)
};

declare %private function permissionslib:checkIfUserDba() {
    if (sm:is-dba(setlib:strCurrentUserName())) then () else (
        error(xs:QName('permissionslib:NotAllowed'), concat('Only dba user can use this module. ',setlib:strCurrentUserName()))
    )
};
