xquery version "3.1";
(:
:   Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
:   see https://art-decor.org/mediawiki/index.php?title=Copyright
:   
:   This program is free software; you can redistribute it and/or modify it under the terms of the
:   GNU Lesser General Public License as published by the Free Software Foundation; either version
:   2.1 of the License, or (at your option) any later version.
:   
:   This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
:   without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
:   See the GNU Lesser General Public License for more details.
:   
:   The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
(:~
 : Variables to indicate common errors
 :)
module namespace errorslib       = "http://art-decor.org/ns/api/errors";

import module namespace roaster     = "http://e-editiones.org/roaster";
import module namespace errors      = "http://e-editiones.org/roaster/errors";

declare function errorslib:get-map-as-xml($errmap as map(*)) {

    let $responsecode   := errors:get-status-code-from-error($errmap?code)
    return
        roaster:response($responsecode, head((roaster:accepted-content-types()[matches(., 'xml|json')], 'application/json')), 
            <error>
                <code>{$errmap?code}</code>
                <description>{$errmap?description}</description>
            {
                if ($responsecode lt 500) then () else (
                    <module>{$errmap?module}</module>,
                    <line>{$errmap?line}</line>,
                    <column>{$errmap?column}</column>
                )
            }
            </error>
        )
};