xquery version "1.0";
(:
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
    see https://art-decor.org/mediawiki/index.php?title=Copyright

    This program is free software; you can redistribute it and/or modify it under the terms of the
    GNU Lesser General Public License as published by the Free Software Foundation; either version
    2.1 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
    without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU Lesser General Public License for more details.

    The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:)
(:
    Module: display running xqueries
:)

declare namespace request   = "http://exist-db.org/xquery/request";
declare namespace xmldb     = "http://exist-db.org/xquery/xmldb";
declare namespace util      = "http://exist-db.org/xquery/util";
declare namespace system    = "http://exist-db.org/xquery/system";
declare option exist:serialize "method=text media-type=text/plain";

let $theactingnotifierusername := if (request:exists()) then request:get-parameter('user', '') else ''
let $theactingnotifierpassword := if (request:exists()) then request:get-parameter('password', '') else ''

let $nl := "&#10;"

return
    if (xmldb:login('/db', $theactingnotifierusername, $theactingnotifierpassword) ) then (
        let $processes := system:get-running-xqueries()//system:xquery
        let $jobs := system:get-running-jobs()//system:job
        return
            if (empty($processes)) then (
                concat('...No running xqueries/jobs are active right now.', $nl)
            ) else (
                concat('...ID Action Info Running Since', $nl),
                for $proc in $processes[not(system:sourceKey/text()='/db/apps/systemtasks/modules/running-jobs.xquery')]
                return (
                    concat('...',
                        $proc/@id/string(), ' ',
                        $proc/system:sourceKey/text(), ' ',
                        $proc/@sourceType/string(), ' ',
                        $proc/@started/string(),
                        $nl
                    )
                )
            )
    ) else ()
