xquery version "3.0";
(:
:   Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
:   see https://art-decor.org/mediawiki/index.php?title=Copyright
:   
:   This program is free software; you can redistribute it and/or modify it under the terms of the
:   GNU Lesser General Public License as published by the Free Software Foundation; either version
:   2.1 of the License, or (at your option) any later version.
:   
:   This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
:   without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
:   See the GNU Lesser General Public License for more details.
:   
:   The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:
:)
import module namespace get         = "http://art-decor.org/ns/art-decor-settings" at "../../../art/modules/art-decor-settings.xqm";
import module namespace art         = "http://art-decor.org/ns/art" at "../../../art/modules/art-decor.xqm";
import module namespace adserver    = "http://art-decor.org/ns/art-decor-server" at "../../../art/api/api-server-settings.xqm";
import module namespace vs          = "http://art-decor.org/ns/decor/valueset" at "../../../art/api/api-decor-valueset.xqm";
import module namespace i18n        = "http://art-decor.org/ns/decor/i18n" at "../../../art/api/api-decor-i18n.xqm";
declare namespace       ihesvs      = "urn:ihe:iti:svs:2008" ;

declare option exist:serialize "method=xhtml indent=no media-type=application/xhtml+html";

declare option exist:timeout "90000";

declare variable $artDeepLinkServices   := adserver:getServerURLServices();
declare variable $useLocalAssets        := if (request:exists()) then request:get-parameter('useLocalAssets','false') else 'false';
declare variable $download              := if (request:exists()) then request:get-parameter('download','false') else '';
(:When called with localAssets=true then we need relative local paths, else 
    we need our server services URL, but with matching scheme (http or https)
    If the scheme is https and servicesUrl is http this leads to a security 
    problem in some browsers
:)
declare variable $resourcePath          := if ($download='true') then ('http://art-decor.org/ADAR/rv/assets') else if ($useLocalAssets = 'true') then ('../assets') else ('../core/assets');

declare variable $format                := if (request:exists() and string-length(request:get-parameter('format','')[1])>0) then request:get-parameter('format','html')[1] else ('html');
declare variable $boolSerialize         := if ($format = ('xml','html')) then false() else true();
declare variable $docMessages           := i18n:getMessagesDoc('decor/services');
declare variable $strArtURL             := adserver:getServerURLArt();

let $dodev              := if (request:exists()) then request:get-parameter('dev','false')='true' else (true())
let $seetype            := if (request:exists()) then request:get-parameter('seetype','live-services') else ('live-services')
let $language           := if (request:exists() and string-length(request:get-parameter('language','')[1])>0) then request:get-parameter('language',$get:strArtLanguage)[1] else ($get:strArtLanguage)
let $languageorig       := if (request:exists()) then request:get-parameter('language','')[1] else ('')

let $id                 := if (request:exists()) then request:get-parameter('id',())[string-length()>0][1] else ()
let $name               := if (request:exists()) then request:get-parameter('name',())[string-length()>0][1] else ()
let $ref                := if (request:exists()) then request:get-parameter('ref',())[string-length()>0][1] else ()
let $useRegexMatching   := if (request:exists()) then request:get-parameter('regex','false')[string-length()>0][1]='true' else ()

let $effectiveDate      := if (request:exists()) then request:get-parameter('effectiveDate',())[string-length()>0][1] else ()
let $projectPrefix      := if (request:exists()) then request:get-parameter('prefix',())[string-length()>0][1] else ()
let $projectVersion     := if (request:exists()) then request:get-parameter('version',())[string-length()>0][1] else ()
let $htmlInline         := if (request:exists() and string-length(request:get-parameter('inline',())[1])>0) then request:get-parameter('inline',())[1] else ()
let $displayHeader      := if ($htmlInline='true') then false() else true()

let $switchDoTreeTable      := if (request:exists()) then request:get-parameter('collapsable','true')='true' else (true())

let $artdecordeeplinkprefix := adserver:getServerURLArt()

let $valueSets          := 
    if ($format = 'fhir-dstu2') then (
        let $redirecturl    := if (empty($projectPrefix)) then ('public') else if (empty($projectVersion)) then $projectPrefix else concat($projectPrefix, '/', $projectVersion)
        let $redirecturl    := concat(adserver:getServerURLFhirServices(), '1.0/', $redirecturl, '/ValueSet/')
        
        let $paramid        := if (empty($id)) then () else concat('identifier=', encode-for-uri($id))
        let $paramnm        := if (empty($name)) then () else concat('name=', encode-for-uri($name))
        let $paramrf        := if (empty($ref)) then () else if (matches($ref, '^[012](\.[\d\.])+$')) then concat('identifier=', encode-for-uri($ref)) else concat('name=', encode-for-uri($ref))
        let $paramed        := if (empty($effectiveDate)) then () else concat('version=', encode-for-uri($effectiveDate))
        
        return
        if (empty($id)) then () else (
            response:redirect-to(xs:anyURI(concat($redirecturl, '?', string-join(($paramid, $paramrf, $paramnm, $paramed), '&amp;'))))
        )
    ) else
    if (not(empty($id))) then
        if (empty($projectPrefix)) then
            vs:getExpandedValueSetById($id,$effectiveDate, $boolSerialize)
        else (
            vs:getExpandedValueSetById($id,$effectiveDate,$projectPrefix, $projectVersion, $language, $boolSerialize)
        )
    
    else if (not(empty($name))) then
        if (empty($projectPrefix)) then
            vs:getExpandedValueSetByName($name, $effectiveDate, $useRegexMatching, $boolSerialize)
        else (
            vs:getExpandedValueSetByName($name, $effectiveDate, $useRegexMatching, $projectPrefix, $projectVersion, $language, $boolSerialize)
        )
    
    else if (not(empty($ref)) and not(empty($projectPrefix))) then
        vs:getExpandedValueSetByRef($ref, $effectiveDate, $projectPrefix, $projectVersion, $language, $boolSerialize)
    
    else if (not(empty($projectPrefix))) then
        let $valueSetList := vs:getValueSetList($id, $name, $effectiveDate, $projectPrefix, $projectVersion)
        for $valueSet in $valueSetList/project[empty(@url)][@ident=$projectPrefix]/valueSet
        return
            vs:getExpandedValueSetById($valueSet/(@id|@ref), $valueSet/@effectiveDate, $projectPrefix, $projectVersion, $language, $boolSerialize)
    else ()

let $valueSetNames      := distinct-values($valueSets//valueSet/@name)
let $valueSetName       := if (count($valueSetNames)>1) then 'multiple' else $valueSetNames

return
    if (string-length($id)=0 and string-length($name)=0 and string-length($projectPrefix)=0) then
        if (request:exists()) then 
            (response:set-status-code(404), response:set-header('Content-Type','text/xml'), <error>{i18n:getMessage($docMessages,'errorRetrieveValuesetNotEnoughParameters',$language)}</error>)
        else ''
    else if (empty($valueSets)) then (
        if ($htmlInline='true') then (
            response:set-status-code(404),
            response:set-header('Content-Type','text/html'),
            <html><head><title>HTTP 404 Not Found</title></head><body/></html>
        ) else (
            response:set-status-code(404),
            response:set-header('Content-Type','text/xml'), 
            <error>{i18n:getMessage($docMessages,'errorRetrieveValuesetNoResults',$language),' ',if (request:exists()) then request:get-query-string() else()}</error>
        )
    )
    else if ($format = 'xml') then (
        if (request:exists()) then (
            response:set-header('Content-Type','application/xml; charset=utf-8'),
            response:set-header('Content-Disposition', concat('filename=VS_',$valueSetName,'_(download_',substring(string(current-dateTime()),1,19),').xml'))
        ) else ()
        ,
        <valueSets>
        {
            $valueSets/*
        }
        </valueSets>
    )
    else if ($format = ('svs','mdibagch')) then (
        (:  KH 20190815
            format mdibagch is a proprietay special type of svs in a different namespace "urn:ch:admin:bag:epr:2017:MdiImport"
            for customer Bundesamt für Gesundheits, Bern, Schweiz
        :)
        if (request:exists()) then (
            response:set-header('Content-Type','text/xml; charset=utf-8'),
            response:set-header('Content-Disposition', concat('filename=VS_',$valueSetName,'_(download_',substring(string(current-dateTime()),1,19),').xml'))
        ) else (),
        let $valuesetcount       := count($valueSets//*:valueSet[@id])
        let $valuesetelementname := if (($valuesetcount > 1) and ($format!='mdibagch')) then 'DescribedValueSet' else 'ValueSet'
        (: KH 20190815 speacial handling of value set element name for mdibagch :)
        let $decor               := art:getDecorByPrefix($projectPrefix, $projectVersion)[1]
        let $url                 := if ($decor) then $decor/project else ()
        let $projectname         := if ($url) then ($url/name)[1] else ()
        let $svs1language        := if (string-length($languageorig)>0) then $languageorig else '' (: default: no language specified :)
        
        let $svsresult           :=  
            for $valueset in $valueSets//*:valueSet[@id]
            let $intensional := $valueset/*:completeCodeSystem or $valueset/*:conceptList/*:include or $valueset/*:conceptList/*:exclude
            let $includerefonly := not($intensional) or ($valueset/*:conceptList/*:include[@ref] and not($valueset/*:completeCodeSystem or $valueset/*:conceptList/*:include[empty(@ref)] or $valueset/*:conceptList/*:exclude))
            let $defaultNamespace-uri   :=
                if ($format='mdibagch')
                then "urn:ch:admin:bag:epr:2017:MdiImport" 
                else "urn:ihe:iti:svs:2008"
                (: KH 20190815 speacial handling of namespaces for mdibagch :)
            let $otherLanguages    := $valueset/*:conceptList/*:concept/*:designation[@language != $svs1language] | 
                                      $valueset/*:conceptList/*:exception/*:designation[@language != $svs1language]
            let $allLanguages      := $valueset/*:conceptList/*:concept/*:designation/@language
            let $hasnodesignations := count($otherLanguages) = 0
            return
                (:<result xmlns="urn:ihe:iti:svs:2008" xmlns:ihesvs="urn:ihe:iti:svs:2008" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">:)
                element {QName($defaultNamespace-uri,"result")} {
                    element {QName($defaultNamespace-uri, $valuesetelementname)} {
                       attribute { "id" } {$valueset/@id},
                       attribute { "displayName" } {if ($valueset/@displayName) then $valueset/@displayName else $valueset/@name},
                       attribute { "version" } {if ($valueset/@versionLabel) then $valueset/@versionLabel else $valueset/@effectiveDate},
   
                       (: Source: This is the source of the value set, identifying the originator or publisher of the information :)
                       let $pa := if ($valueset/*:publishingAuthority/@name) then data($valueset/*:publishingAuthority/@name) else ()
                       let $cr := if ($valueset/*:copyright) then $valueset/*:copyright else ()
                       return if ($pa or $cr) then 
                           <Source>
                           {
                               $pa
                           }
                           {
                               if ($pa) then ' - ' else (),
                               string-join($cr/text(), ' - ')
                           }
                           </Source> 
                           else (),
   
                       (: Purpose: Brief description about the general purpose of the value set :)
                       if ($valueset/*:desc[@language="en-US"])
                       then <Purpose>{$valueset/*:desc[@language="en-US"]/text()}</Purpose> 
                       else if ($valueset/*:desc[not(@language="en-US")][1]) 
                       then <Purpose>{concat(data($valueset/*:desc/@language), ': ')}{$valueset/*:desc[not(@language="en-US")][1]/text()}</Purpose> 
                       else (),
   
                       (: Active, Inactive, local extensions :)
                       if ($valueset/@statusCode=("final", "draft"))
                       then <Status>Active</Status>
                       else if ($valueset/@statusCode=("rejected", "cancelled", "deprecated"))
                       then <Status>Inactive</Status>
                       else <Status>{data($valueset/@statusCode)}</Status>,
                   
                       (: Type: This describes the type of the value set. It shall be Intensional, Extensional, or Expanded.
                                Note: This is the type of the value set in the repository. The ConceptList that will also be returned is the current expansion of the value set.
                       :)
                       if ($intensional) 
                       then <Type>Intensional</Type>
                       else <Type>Extensional</Type>,
                  
                       (: Effective Date The date when the value set is expected to be effective, defaults to effectiveDate :)
                       if ($valueset/@officialReleaseDate)
                       then <EffectiveDate>{data(substring($valueset/@officialReleaseDate,1, 10))}</EffectiveDate>
                       else <EffectiveDate>{data(substring($valueset/@effectiveDate,1, 10))}</EffectiveDate>,
                   
                       (: Expiration Date: The date when the value set is no longer expected to be used :)
                       if ($valueset/@expirationDate)
                       then <ExpirationDate>{data(substring($valueset/@expirationDate,1, 10))}</ExpirationDate>
                       else (),
                   
                       (: Creation Date: The date of creation of the value set :)
                       if ($valueset/@effectiveDate)
                       then <CreationDate>{data(substring($valueset/@effectiveDate,1, 10))}</CreationDate>
                       else (),
                   
                       if (not($intensional) or $includerefonly)
                       then
                            (
                            if ( (string-length($svs1language) = 0) or ($hasnodesignations) )
                            then
                                (
                                 for $lang in distinct-values($allLanguages)
                                 return
                                    <ConceptList xml:lang="{$lang}">
                                    {
                                        for $concept in ($valueset/*:conceptList/*:concept | $valueset/*:conceptList/*:exception)
                                        let $d := if ($concept/designation[@language=$lang]) then $concept/designation[@language=$lang] else $concept
                                        let $conceptCode              := data($concept/@code)
                                        let $conceptCodeSystem        := data($concept/@codeSystem)
                                        let $conceptDisplayName       := data($d/@displayName)
                                        let $conceptCodeSystemVersion := data($concept/@codeSystemVersion)
                                        return
                                        <Concept code="{$conceptCode}" codeSystem="{$conceptCodeSystem}" displayName="{$conceptDisplayName}">
                                        {
                                            if (string-length($conceptCodeSystemVersion) > 0) then $conceptCodeSystemVersion else ()
                                        }
                                        </Concept>
                                    }
                                    </ConceptList>
                               )
                            else
                                (: a sepcfic language is specified, find the designations :)
                                <ConceptList xml:lang="{$svs1language}">
                                {
                                    for $concept in ($valueset/*:conceptList/*:concept | $valueset/*:conceptList/*:exception)
                                    let $d := if ($concept/designation[@language=$svs1language]) then $concept/designation[@language=$svs1language] else $concept
                                    let $conceptCode              := data($concept/@code)
                                    let $conceptCodeSystem        := data($concept/@codeSystem)
                                    let $conceptDisplayName       := data($d/@displayName)
                                    let $conceptCodeSystemVersion := data($concept/@codeSystemVersion)
                                    return
                                    <Concept code="{$conceptCode}" codeSystem="{$conceptCodeSystem}" displayName="{$conceptDisplayName}">
                                    {
                                        if (string-length($conceptCodeSystemVersion) > 0) then $conceptCodeSystemVersion else ()
                                    }
                                    </Concept>
                                
                                }
                                </ConceptList>
                            )
                       else (<!-- Intensional Value Set not expanded -->),
                       (:
                           Place Project OID if available in Group
                           <Group id="2.16.840.1.113883.3.1937.777.13" displayName="International Patient Summary (IPS)" sourceOrganization="ART-DECOR Expert Group">
                       :)
                       if ($url)
                           then
                               <Group id="{$url/@id}" displayName="{$projectname}" sourceOrganization="ART-DECOR Expert Group">
                               {
                                   <Keyword>ART-DECOR Project</Keyword>
                               }
                               </Group>
                           else () 
                   }
              }
            
        return
            if ($format='mdibagch')
            then
                (: KH 20190815 speacial handling for mdibagch, no cacheExpirationHint="{format-dateTime(current-dateTime(), '[Y0001]-[M01]-[D01]T[H01]:[m01]:[s01]')}" :)
                <RetrieveMultipleValueSetsResponse 
                        xmlns="urn:ch:admin:bag:epr:2017:MdiImport" xmlns:ihesvs="urn:ihe:iti:svs:2008" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
                {
                        $svsresult/*
                }
                </RetrieveMultipleValueSetsResponse>
            else
                (: standard svs format :)
                if ($valuesetcount > 1)
                then
                    <RetrieveMultipleValueSetsResponse 
                        xmlns="urn:ihe:iti:svs:2008" xmlns:ihesvs="urn:ihe:iti:svs:2008" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                        cacheExpirationHint="{format-dateTime(current-dateTime(), '[Y0001]-[M01]-[D01]T[H01]:[m01]:[s01]')}">
                    {
                        $svsresult/*
                    }
                    </RetrieveMultipleValueSetsResponse>
                else
                    <RetrieveValueSetResponse 
                        xmlns="urn:ihe:iti:svs:2008" xmlns:ihesvs="urn:ihe:iti:svs:2008" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                        cacheExpirationHint="{format-dateTime(current-dateTime(), '[Y0001]-[M01]-[D01]T[H01]:[m01]:[s01]')}">
                    {
                        $svsresult/*
                    }
                    </RetrieveValueSetResponse>
            
    ) 
    else if ($format = 'svsold') then (
        if (request:exists()) then (
            response:set-header('Content-Type','text/xml; charset=utf-8'),
            response:set-header('Content-Disposition', concat('filename=VS_',$valueSetName,'_(download_',substring(string(current-dateTime()),1,19),').xml'))
        ) else ()
        ,
        <RetrieveValueSetResponse xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="urn:ihe:iti:svs:2008" cacheExpirationHint="{format-dateTime(current-dateTime(), '[Y0001]-[M01]-[D01]T[H01]:[m01]:[s01]')}">
        {
            for $valueset in $valueSets//*:valueSet[@id]
            return
                <ValueSet id="{$valueset/@id}" displayName="{if ($valueset/@displayName) then $valueset/@displayName else $valueset/@name}" version="{if ($valueset/@versionLabel) then $valueset/@versionLabel else $valueset/@effectiveDate}">
                {
                    <ConceptList xml:lang="en-US">
                    {
                        for $concept in ($valueset/*:conceptList/*:concept | $valueset/*:conceptList/*:exception)
                        let $conceptCode        := data($concept/@code)
                        let $conceptCodeSystem  := data($concept/@codeSystem)
                        let $conceptDisplayName := data($concept/@displayName)
                        return
                        <Concept code="{$conceptCode}" codeSystem="{$conceptCodeSystem}" displayName="{$conceptDisplayName}" />
                    }
                    </ConceptList>,
                    let $otherLanguages := ($valueset/*:conceptList/*:concept/*:designation[@language != 'en-US'] | 
                                            $valueset/*:conceptList/*:exception/*:designation[@language != 'en-US'])
                    return
                    if ($otherLanguages) then
                        for $lang in distinct-values($otherLanguages/@language)
                        return
                            if (string-length($languageorig) = 0 or (string-length($languageorig) > 0 and $languageorig=$lang))
                            then
                                <ConceptList xml:lang="{$lang}">
                                {
                                    for $d in ($otherLanguages[@language=$lang])
                                    let $designationDisplayName := data($d/@displayName)
                                    let $conceptCode            := data($d/parent::*/@code)
                                    let $conceptCodeSystem      := data($d/parent::*/@codeSystem)
                                    return
                                    <Concept code="{$conceptCode}" codeSystem="{$conceptCodeSystem}" displayName="{$designationDisplayName}" />
                                }
                                </ConceptList>
                            else ()
                    else ()
                }
                </ValueSet>
        }
        </RetrieveValueSetResponse>
    ) 
    else if ($format = 'csv') then (
        if (request:exists()) then (
            response:set-header('Content-Type','text/csv; charset=utf-8'),
            response:set-header('Content-Disposition', concat('filename=VS ',($valueSets//project/valueSet/@name)[1],' (download ',substring(string(current-dateTime()),1,19),').csv'))
        ) else ()
        ,
        let $mapentries :=
            for $d in distinct-values($valueSets//designation/string-join((@type,@language),' / '))
            return map:entry($d, max($valueSets//*/count(designation[$d = string-join((@type,@language),' / ')])))
        let $designationmap     := map:merge($mapentries)
        let $header             := 
            concat('Level;Type;Code;DisplayName;CodeSystem;CodeSystemName;CodeSystemVersion;Flexibility;Exception',
                if (count($mapentries)=0) then () else (
                    concat(';',string-join(
                        for $d in map:keys($designationmap)
                        for $i in (1 to map:get($designationmap, $d))
                        return concat('&quot;Designation ',$d,'&quot;')
                    ,';'))
                )
            ,'&#13;&#10;')
        let $columncount        := count(tokenize($header,';'))
        let $i18nvalueset       := i18n:getMessage($docMessages,'ValueSet',$language)
        return (
        (:<concept code="xxxxxx" codeSystem="2.16.840.1.113883.2.4.15.4" displayName="Medicatie" level="0" type="A"/> :)
        (: Replace double quotes with single quotes in the CSV values, except in the code itself, 
        and place in between double quotes if there a white space character in a string
        Note that in the exceptional event that a code contains a double quote, the CSV renders invalid :)
        for $valueset at $i in $valueSets//valueSet[@id]
        return (
            if ($i > 1) then ('&#13;&#10;') else (),
            concat('&quot;',$i18nvalueset,' ',$valueset/@displayName,' - ',$valueset/(@id|@ref),' ',$valueset/@effectiveDate,'&quot;',string-join(for $i in (1 to ($columncount - 1)) return ';',''),'&#13;&#10;'),
            $header,
            for $concept in ($valueset/completeCodeSystem, $valueset/conceptList/concept, $valueset/conceptList/exception)
                let $conceptCode                    := data($concept/@code)
                let $quotedConceptCode              := if (matches($conceptCode,'\s+')) then (concat('&quot;',$conceptCode,'&quot;')) else ($conceptCode)
                let $conceptDisplayName             := replace(data($concept/@displayName),'"','&apos;')
                let $quotedConceptDisplayName       := if (matches($conceptDisplayName,'\s+')) then (concat('&quot;',$conceptDisplayName,'&quot;')) else ($conceptDisplayName)
                let $conceptCodeSystem              := replace(data($concept/@codeSystem),'"','&apos;')
                let $quotedConceptCodeSystem        := if (matches($conceptCodeSystem,'\s+')) then (concat('&quot;',$conceptCodeSystem,'&quot;')) else ($conceptCodeSystem)
                let $generatedCodeSystemName        := art:getNameForOID($concept/@codeSystem,$language,$projectPrefix)
                let $conceptCodeSystemName          := replace(if ($concept/@codeSystemName) then (data($concept/@codeSystemName)) else if (replace($generatedCodeSystemName,'[0-9\.]','')!='') then ($generatedCodeSystemName) else (''),'"','&apos;')
                let $quotedConceptCodeSystemName    := if (matches($conceptCodeSystemName,'\s+')) then (concat('&quot;',$conceptCodeSystemName,'&quot;')) else ($conceptCodeSystemName)
                let $conceptCodeSystemVersion       := replace(data($concept/@codeSystemVersion),'"','&apos;')
                let $quotedConceptCodeSystemVersion := if (matches($conceptCodeSystemVersion,'\s+')) then (concat('&quot;',$conceptCodeSystemVersion,'&quot;')) else ($conceptCodeSystemVersion)
                let $conceptFlexibility             := if ($concept[self::completeCodeSystem]) then (replace(if ($concept/@flexibility) then (data($concept/@flexibility)) else ('dynamic'),'"','&apos;')) else ('')
                let $quotedconceptFlexibility       := if (matches($conceptFlexibility,'\s+')) then (concat('&quot;',$conceptFlexibility,'&quot;')) else ($conceptFlexibility)
                let $quotedException                := $concept/name()='exception'
            return (
                concat(data($concept/@level),';',data($concept/@type),';',$quotedConceptCode,';',$quotedConceptDisplayName,';',$quotedConceptCodeSystem,';',$quotedConceptCodeSystemName,';',$quotedConceptCodeSystemVersion,';',$quotedconceptFlexibility,';',$quotedException,
                    concat(';',string-join(
                        for $d in map:keys($designationmap)
                        for $i in (1 to map:get($designationmap, $d))
                        let $designation    := $concept/designation[$d=string-join((@type,@language),' / ')][1]
                        return 
                            if ($designation[@displayName]) then
                            if (matches($designation/@displayName,'\s+')) then (
                                concat('&quot;',$designation/@displayName,'&quot;')
                            ) else (
                                $designation/@displayName
                            )
                            else ('')
                    ,';'))
                ,'&#13;&#10;')
            )
        ))
    ) 
    else if ($format = 'sql') then (
        if (request:exists()) then (
            response:set-header('Content-Type','text/csv; charset=utf-8'),
            response:set-header('Content-Disposition', concat('filename=VS ',if (count($valueSets//valueSet)=1) then $valueSets//valueSet/@name[1] else $projectPrefix,' (download ',substring(string(current-dateTime()),1,19),').sql'))
        ) else ()
        ,
        let $SQL := transform:transform($valueSets, doc('../resources/stylesheets/ToSql4ValueSets.xsl'), ())
        return $SQL
    )
    else if ($format = 'json') then (
        if (request:exists()) then (
            response:set-header('Content-Type','application/json; charset=utf-8'),
            response:set-header('Content-Disposition', concat('filename=VS ',if (count($valueSets//valueSet)=1) then $valueSets//valueSet/@name[1] else $projectPrefix,' (download ',substring(string(current-dateTime()),1,19),').json'))
        ) else ()
        ,
        let $xml  := 
            element {'valueSets'} {
                namespace {"json"} {"http://www.json.org"}, 
                art:addJsonArrayToElements($valueSets//valueSet[@id])
            }
        
        return
            fn:serialize($xml,
                <output:serialization-parameters xmlns:output="http://www.w3.org/2010/xslt-xquery-serialization">
                    <output:method>json</output:method>
                    <output:encoding>UTF-8</output:encoding>
                </output:serialization-parameters>
            )
    )
    else (
        let $xsltParameters     :=
            <parameters>
                <param name="projectDefaultLanguage"    value="{$language}"/>
                <param name="artdecordeeplinkprefix"    value="{$artdecordeeplinkprefix}"/>
                <param name="seeThisUrlLocation"        value="{$seetype}"/>
                <param name="displayHeader"             value="{$displayHeader}"/>
                <param name="rand"                      value="128"/>
                <param name="logLevel"                  value="'OFF'"/>
                <param name="bindingBehaviorValueSetsURL" value="{concat($artDeepLinkServices,'RetrieveValueSet?prefix=',$projectPrefix,'&amp;language=',$language,'&amp;version=',$projectVersion)}"/>
                <!--<param name="bindingBehaviorValueSets" select="'preserve'"/>
                <param name="theBaseURI2DECOR"/>-->
                <param name="switchCreateTreeTableHtml" value="{$switchDoTreeTable}"/>
            </parameters>
        let $xslt := 
            if ($dodev) then 
                xs:anyURI('http://art-decor.org/ADAR-dev/rv/ValueSet2html.xsl')
            else (
                (:xs:anyURI(concat('xmldb:exist://', $get:strDecorCore, '/ValueSet2html.xsl')):)
                xs:anyURI('http://art-decor.org/ADAR/rv/ValueSet2html.xsl')
            )
        let $collapseString     := try { i18n:getMessage($docMessages,'Collapse',$language) } catch * {'Collapse'}
        let $expandString       := try { i18n:getMessage($docMessages,'Expand',$language) } catch * {'Expand'}
        let $logo                       := 
            if ($projectPrefix[string-length()>0]) then (
                concat('ProjectLogo?prefix=',$projectPrefix[string-length()>0][1],'&amp;version=',encode-for-uri($projectVersion[1]))
            ) else (
                let $server-logo    := adserver:getServerLogo()
                return if (starts-with($server-logo, 'http')) then $server-logo else concat('/art-decor/img/', $server-logo)
            )
        let $decor                      := art:getDecorByPrefix($projectPrefix, $projectVersion)[1]
        let $url                        := if ($projectPrefix[string-length()>0]) then ($decor/project/reference/@url) else ()
        let $headerGoTo                 := i18n:getMessage($docMessages,'goTo',$language)
        let $vscount                    := count($valueSets/descendant-or-self::valueSet[@id])
        (:this preserves configuration like @deeplinkprefix, and project/restURI for FHIR:)
        let $valueSetPackage            := <decor>{$decor/@*, $decor/project}<terminology>{$valueSets}</terminology></decor>
        return (
        if (request:exists()) then (
            response:set-header('Content-Type','text/html')
        ) else ()
        ,
        <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="{substring($language,1,2)}" lang="{substring($language,1,2)}">
            <head>
                <meta http-equiv="Content-Type" content="text/xhtml; charset=utf-8"/>
                <title>{i18n:getMessage($docMessages, 'ValueSet', $language),' ',($valueSets//@name)[1]/string()}</title>
                {
                    if ($switchDoTreeTable) then (
                        <!--{if ($collapsed) then <script type="text/javascript">window.treeTableCollapsed=true;</script> else <script type="text/javascript">window.treeTableCollapsed=false;</script>}--> |
                        <link href="{$resourcePath}/css/retrieve-template.css" rel="stylesheet" type="text/css"></link> |
                        <script type="text/javascript" xmlns="http://www.w3.org/1999/xhtml">
                            window.treeTableCollapsed = true;
                            window.treeTableStringCollapse = '{$collapseString}';
                            window.treeTableStringExpand = '{$expandString}';
                            window.treeTableColumn = 0;
                        </script> |
                        <script src="{$resourcePath}/scripts/jquery-1.11.3.min.js" type="text/javascript"></script> |
                        <script src="{$resourcePath}/scripts/jquery.treetable.js" type="text/javascript"></script> |
                        <script src="{$resourcePath}/scripts/retrieve-transaction.js" type="text/javascript"></script> |
                        <!--<script src="{$resourcePath}/scripts/jquery.cookie.js" type="text/javascript"></script>--> |
                        <!--{if ($draggable) then <script src="{$resourcePath}/scripts/dragtable.js" type="text/javascript"></script> else ()}--> |
                        <link href="{$resourcePath}/decor.css" rel="stylesheet" type="text/css"></link> |
                        <style type="text/css">body {{ background-color: white; }}</style>
                    ) else (
                        <link href="{$resourcePath}/decor.css" rel="stylesheet" type="text/css"></link>
                    )
                }
            </head>
            <body>
            {
                if ($displayHeader) then (
                    <table width="100%">
                        <tr>
                            <td align="left">
                                <h1>
                                {
                                    if ($vscount = 1) then 
                                        i18n:getMessage($docMessages,'ValueSet',$language) 
                                    else
                                        i18n:getMessage($docMessages,'ValueSets',$language)
                                }
                                </h1>
                            </td>
                            <td align="right">
                            {if ($logo and $url) then 
                                <a href="{$url}">
                                    <img src="{$logo}" alt="" title="{$url}" height="50px"/>
                                </a>
                             else if ($logo) then
                                <img src="{$logo}" alt="" height="50px"/>
                             else ()
                            }
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                {$headerGoTo}
                                <a href="ValueSetIndex?prefix={$projectPrefix}{if (empty($projectVersion)) then () else concat('&amp;version=',$projectVersion)}&amp;language={$language}" alt="">index</a> 
                            </td>
                        </tr>
                    </table>
                )
                else()
            }
            {
                transform:transform($valueSetPackage, $xslt, $xsltParameters)
            }
            </body>
        </html>
        )
    )