xquery version "3.1";
(:
    ART-DECOR® STANDARD COPYRIGHT AND LICENSE NOTE
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools GmbH
    see https://docs.art-decor.org/copyright and https://docs.art-decor.org/licenses

    This file is part of the ART-DECOR® tools suite.
:)

import module namespace tmapi       = "http://art-decor.org/ns/api/template" at "../../../api/modules/template-api.xqm";
import module namespace errors      = "http://e-editiones.org/roaster/errors";

declare option exist:timeout "90000";  (: see https://art-decor.atlassian.net/browse/AD30-2071 :)

let $format                     := if (request:exists() and string-length(request:get-parameter('format','')[1])>0) then request:get-parameter('format','html')[1] else ('html')

let $projectPrefix              := if (request:exists()) then request:get-parameter('prefix',())[string-length()>0][1] else ()
let $projectVersion             := if (request:exists()) then request:get-parameter('version',())[string-length()>0][1] else ()
let $language                   := if (request:exists()) then request:get-parameter('language',()) else ()

let $id                         := if (request:exists()) then request:get-parameter('id',())[string-length()>0][1] else ()
let $name                       := if (request:exists()) then request:get-parameter('name',())[string-length()>0][1] else ()
let $ref                        := if (request:exists()) then request:get-parameter('ref',())[string-length()>0][1] else ()

let $effectiveDate              := if (request:exists()) then request:get-parameter('effectiveDate',())[string-length()>0][1] else ()

let $seetype                    := if (request:exists()) then request:get-parameter('seetype', 'live-services') else ('live-services')
let $inline                     := if (request:exists()) then request:get-parameter('inline', ())='true' else false()
let $collapsable                := if (request:exists()) then request:get-parameter('collapsable','true')='true' else (true())

let $id                         := ($id, $name, $ref)[1]

let $tree                       := 
    switch ($format)
    case 'expandedxml' return 'expand'
    case 'xml' return 'wrap'
    default return ()

return 
    if ($id) then (
        switch ($format)
        case 'html'
        return (
            tmapi:getTemplateView(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "inline" : $inline,
                    "collapsable": $collapsable,
                    "seetype": $seetype,
                    "id": $id,
                    "effectiveDate": $effectiveDate
                    }
                }
            )
        )
        default return (
            tmapi:getTemplateExtract(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "tree": $tree,
                    "id": $id,
                    "effectiveDate": $effectiveDate
                    }
                }
            )
        )
    ) else 
    if ($seetype = 'live') then 
        (: when called from AD2 there is one call just before the actual call that is hard to suppress that does 
           not have an id yet. 404 will suffice so as to not burden the user with that call by giving and error :)
        response:set-status-code(404)    
    else (
        error($errors:BAD_REQUEST, 'Parameter id, name or ref is required, without effectiveDate you get the latest version')
    )
