xquery version "3.1";
(:
    ART-DECOR® STANDARD COPYRIGHT AND LICENSE NOTE
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools GmbH
    see https://docs.art-decor.org/copyright and https://docs.art-decor.org/licenses

    This file is part of the ART-DECOR® tools suite.
:)

import module namespace csapi       = "http://art-decor.org/ns/api/codesystem" at "../../../api/modules/codesystem-api.xqm";
import module namespace errors      = "http://e-editiones.org/roaster/errors";

declare option exist:timeout "90000";

let $format                     := if (request:exists() and string-length(request:get-parameter('format','')[1])>0) then request:get-parameter('format','html')[1] else ('html')

let $projectPrefix              := if (request:exists()) then request:get-parameter('prefix',())[string-length()>0][1] else ()
let $projectVersion             := if (request:exists()) then request:get-parameter('version',())[string-length()>0][1] else ()
let $language                   := if (request:exists()) then request:get-parameter('language',()) else ()

let $id                         := if (request:exists()) then request:get-parameter('id',())[string-length()>0][1] else ()
let $name                       := if (request:exists()) then request:get-parameter('name',())[string-length()>0][1] else ()
let $ref                        := if (request:exists()) then request:get-parameter('ref',())[string-length()>0][1] else ()

let $effectiveDate              := if (request:exists()) then request:get-parameter('effectiveDate',())[string-length()>0][1] else ()

let $seetype                    := if (request:exists()) then request:get-parameter('seetype', 'live-services') else ('live-services')
let $inline                     := if (request:exists()) then request:get-parameter('inline', ())='true' else false()
let $collapsable                := if (request:exists()) then request:get-parameter('collapsable','true')='true' else (true())

let $idOrName                   := ($id, $name, $ref)[1]
let $withVersions               := not($effectiveDate[string-length() gt 0])

let $result                     :=
    switch ($format)
    case 'html'
    return (
        if ($idOrName) then (
           csapi:getCodeSystemView(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "seetype": $seetype,
                    "inline" : $inline,
                    "collapsable": $collapsable,
                    "idOrName": $idOrName,
                    "effectiveDate": $effectiveDate,
                    "format": $format
                    }
                }
            )
        )
        else (
            error($errors:BAD_REQUEST, 'Parameter id, name or ref is required, without effectiveDate you get the latest version')
        )
    )
    default return (
        if ($idOrName) then (
            csapi:getCodeSystemExtract(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "versions": $withVersions,
                    "format": $format,
                    "idOrName": $idOrName,
                    "effectiveDate": $effectiveDate
                    }
                }
            )
        )
        else if ($projectPrefix) then (
             csapi:getCodeSystemExtractList(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "format": $format
                    }
                }
            )
        )
        else (
            error($errors:BAD_REQUEST, 'For a codesystem parameter id, name or ref is required, without effectiveDate you get all versions. For a codesystem list project prefix is required.')
        )
    )
    
return 
    if ($result instance of element() or $result instance of xs:string) then $result else if (response:exists()) then response:set-status-code(404) else ()    
