xquery version "3.1";
(:
    ART-DECOR® STANDARD COPYRIGHT AND LICENSE NOTE
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools GmbH
    see https://docs.art-decor.org/copyright and https://docs.art-decor.org/licenses

    This file is part of the ART-DECOR® tools suite.
:)

import module namespace mpapi       = "http://art-decor.org/ns/api/conceptmap" at "../../../api/modules/conceptmap-api.xqm";
import module namespace errors      = "http://e-editiones.org/roaster/errors";

declare option exist:timeout "90000";  (: see https://art-decor.atlassian.net/browse/AD30-2071 :)

let $format                     := if (request:exists() and string-length(request:get-parameter('format','')[1])>0) then request:get-parameter('format','html')[1] else ('html')

let $projectPrefix              := if (request:exists()) then request:get-parameter('prefix',())[string-length()>0][1] else ()
let $projectVersion             := if (request:exists()) then request:get-parameter('version',())[string-length()>0][1] else ()
let $language                   := if (request:exists()) then request:get-parameter('language',()) else ()

let $id                         := if (request:exists()) then request:get-parameter('id',())[string-length()>0][1] else ()
let $ref                        := if (request:exists()) then request:get-parameter('ref',())[string-length()>0][1] else ()

let $effectiveDate              := if (request:exists()) then request:get-parameter('effectiveDate',())[string-length()>0][1] else ()

let $seetype                    := if (request:exists()) then request:get-parameter('seetype', 'live-services') else ('live-services')

let $id                         := ($id, $ref)[1]

let $result                     := 
    if ($id) then (
        switch ($format)
        case 'html'
        return (
            mpapi:getConceptMapView(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "seetype": $seetype,
                    "id": $id,
                    "effectiveDate": $effectiveDate,
                    "format": $format
                    }
                }
            )
        )
        default return (
            mpapi:getConceptMapExtract(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "id": $id,
                    "effectiveDate": $effectiveDate,
                    "format": $format
                    }
                }
            )
        )
    ) 
    else (
        error($errors:BAD_REQUEST, 'Parameter id or ref is required, without effectiveDate you get all versions')
    )

return 
    typeswitch ($result)
    case map() return if (response:exists()) then response:set-status-code(404) else ()
    default return $result

