xquery version "3.1";
(:
    ART-DECOR® STANDARD COPYRIGHT AND LICENSE NOTE
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools GmbH
    see https://docs.art-decor.org/copyright and https://docs.art-decor.org/licenses

    This file is part of the ART-DECOR® tools suite.
:)

import module namespace csapi       = "http://art-decor.org/ns/api/codesystem" at "../../../api/modules/codesystem-api.xqm";
import module namespace router      = "http://e-editiones.org/roaster/router";
import module namespace errors      = "http://e-editiones.org/roaster/errors";
declare namespace output = "http://www.w3.org/2010/xslt-xquery-serialization";

declare option exist:timeout "90000";

let $format                     := if (request:exists() and string-length(request:get-parameter('format','')[1])>0) then request:get-parameter('format','html')[1] else ('html')

let $projectPrefix              := if (request:exists()) then request:get-parameter('prefix',())[string-length()>0][1] else ()
let $projectVersion             := if (request:exists()) then request:get-parameter('version',())[string-length()>0][1] else ()
let $language                   := if (request:exists()) then request:get-parameter('language',()) else ()

let $id                         := if (request:exists()) then request:get-parameter('id',())[string-length()>0][1] else ()
let $name                       := if (request:exists()) then request:get-parameter('name',())[string-length()>0][1] else ()
let $ref                        := if (request:exists()) then request:get-parameter('ref',())[string-length()>0][1] else ()

let $effectiveDate              := if (request:exists()) then request:get-parameter('effectiveDate',())[string-length()>0][1] else ()

let $download                   := if (request:exists()) then request:get-parameter('download',())[1]='true' else ()
let $seetype                    := if (request:exists()) then request:get-parameter('seetype', 'live-services') else ('live-services')
let $inline                     := if (request:exists()) then request:get-parameter('inline', ())='true' else false()
let $collapsable                := if (request:exists()) then request:get-parameter('collapsable','true')='true' else (true())

let $idOrName                   := ($id, $name, $ref)[1]
let $withVersions               := not($effectiveDate[string-length() gt 0])

let $result                     :=
    switch ($format)
    case 'html'
    return (
        if ($idOrName) then (
           csapi:getCodeSystemView(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "seetype": $seetype,
                    "inline" : $inline,
                    "collapsable": $collapsable,
                    "idOrName": $idOrName,
                    "effectiveDate": $effectiveDate,
                    "format": $format
                    }
                }
            )
        )
        else (
            error($errors:BAD_REQUEST, 'Parameter id, name or ref is required, without effectiveDate you get the latest version')
        )
    )
    default return (
        if ($idOrName) then (
            csapi:getCodeSystemExtract(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "versions": $withVersions,
                    "idOrName": $idOrName,
                    "effectiveDate": $effectiveDate,
                    "format": $format,
                    "download": $download
                    }
                }
            )
        )
        else if ($projectPrefix) then (
             csapi:getCodeSystemExtractList(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "format": $format,
                    "download": $download
                    }
                }
            )
        )
        else (
            error($errors:BAD_REQUEST, 'For a codesystem parameter id, name or ref is required, without effectiveDate you get all versions. For a codesystem list project prefix is required.')
        )
    )
    
return 
    typeswitch ($result)
    case map() return (
        if (response:exists()) then response:set-status-code(($result?($router:RESPONSE_CODE), 200)[1]) else (),
    if ($format = 'json') then util:declare-option("output:method", 'json') else (),
        $result?($router:RESPONSE_BODY)
    )
    default return (
        switch ($format)
        case 'json' return serialize($result, map{"method": "json"})
        default return $result
    )
