xquery version "3.0";
(:
:   Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools
:   see https://art-decor.org/mediawiki/index.php?title=Copyright
:   
:   This program is free software; you can redistribute it and/or modify it under the terms of the
:   GNU Lesser General Public License as published by the Free Software Foundation; either version
:   2.1 of the License, or (at your option) any later version.
:   
:   This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
:   without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
:   See the GNU Lesser General Public License for more details.
:   
:   The full text of the license is available at http://www.gnu.org/copyleft/lesser.html
:
:)
(:
    experimental now
:)
import module namespace get         = "http://art-decor.org/ns/art-decor-settings" at "../../../art/modules/art-decor-settings.xqm";
import module namespace templ       = "http://art-decor.org/ns/decor/template" at "../../../art/api/api-decor-template.xqm";
import module namespace i18n        = "http://art-decor.org/ns/decor/i18n" at "../../../art/api/api-decor-i18n.xqm";
import module namespace art         = "http://art-decor.org/ns/art";


declare namespace svg               = "http://www.w3.org/2000/svg";
declare namespace xlink             = "http://www.w3.org/1999/xlink";
declare variable $templang          := if (request:exists()) then request:get-parameter('language',$get:strArtLanguage) else ($get:strArtLanguage);
declare variable $language          := if ($templang = (art:getArtLanguages())) then $templang else 'en-US';
declare variable $docMessages       := i18n:getMessagesDoc('decor/services');

declare variable $i18nmap           :=
            map:merge((
                map:entry('contains', i18n:getMessage($docMessages,'contains',$language))
            ));

declare %private function local:showDate ($date as xs:dateTime) as xs:string {
    let $displaydate    :=
        if ($date castable as xs:dateTime) then 
            replace(substring($date,1,19),'T00:00:00','')
        else ($date)
    return
        replace($displaydate, '-', '&#8209;')
};

declare %private function local:templateScan ($t as element()?, $projectPrefix as xs:string, $by as xs:string, $indent as xs:int, $ylevel as xs:int, $templatesSoFar as xs:string*) as element()* {
(: get the templates, elements and include chain :)
    if (empty($t)) then (
    ) else 
    if ($t[self::template]) then (
        <template>
        {
            $t/@id,
            $t/@name,
            $t/@displayName,
            attribute effectiveDate {local:showDate($t/@effectiveDate)},
            attribute by {$by},
            attribute len {
                max((string-length($t/@id),string-length($t/@name))) + 
                string-length($t/@effectiveDate) + 
                string-length(map:get($i18nmap, 'contains')) + 
                1
            }
        }
        {
             attribute classification {$t/classification/@type/string()}
        }
        {
            for $lc at $step in ($t//element[@contains] | $t//include[@ref])
            let $xid    := if ($lc[self::element]) then $lc/@contains else $lc/@ref
            let $lcby   := if ($lc[self::element]) then map:get($i18nmap, 'contains') else $lc/name()
            let $xflx   := if ($lc[@flexibility]) then $lc/@flexibility else 'dynamic'
            let $lct    := templ:getTemplateByRef($xid,$xflx,$projectPrefix)/*/template[@id][1]
            return 
                if ($templatesSoFar[.=$lct/concat(@id,@effectiveDate)]) then (
                    <template recurse="true">
                    {
                        $lct/(@id | @name | @displayName),
                        attribute effectiveDate {local:showDate($lct/@effectiveDate)},
                        attribute by {$by},
                        attribute len {
                            max((string-length($lct/@id),string-length($lct/@name))) + 
                            string-length($lct/@effectiveDate) + 
                            string-length(map:get($i18nmap, 'contains')) + 
                            1
                        }
                    }
                    </template>
                ) else (
                    local:templateScan ($lct, $projectPrefix, $lcby, $indent + 1, $ylevel + $step, ($templatesSoFar, $lct/concat(@id,@effectiveDate)))
                )
        }
        </template>
    ) else 
    if ($t[self::element][@contains]) then (
        <element>
        {
            $t/@contains,
            $t/@flexibility,
            attribute by {$by},
            attribute len { string-length($t/@contains) + string-length($t/@flexibility) }
        }
        {
            for $lc at $step in ($t//element[@contains] | $t//include[@ref])
            let $xid    := if ($lc[self::element]) then $lc/@contains else $lc/@ref
            let $lcby   := if ($lc[self::element]) then map:get($i18nmap, 'contains') else $lc/name()
            let $xflx   := if ($lc[@flexibility]) then $lc/@flexibility else 'dynamic'
            let $lct    := templ:getTemplateByRef($xid,$xflx,$projectPrefix)/*/template[@id]
            return 
                if ($templatesSoFar[.=$lct/concat(@id,@effectiveDate)]) then (
                    <template recurse="true">
                    {
                        $lct/(@id | @name | @displayName),
                        attribute effectiveDate {local:showDate($lct/@effectiveDate)},
                        attribute by {$by},
                        attribute len {
                            max((string-length($lct/@id),string-length($lct/@name))) + 
                            string-length($lct/@effectiveDate) + 
                            string-length(map:get($i18nmap, 'contains')) + 
                            1
                        }
                    }
                    </template>
                ) else (
                    local:templateScan ($lct, $projectPrefix, $lcby, $indent + 1, $ylevel + $step, ($templatesSoFar, $lct/concat(@id,@effectiveDate)))
                )
        }
        </element>
    ) else 
    if ($t[self::include][@ref]) then (
        <include>
        {
            $t/@ref,
            $t/@flexibility,
            attribute by {$by},
            attribute len { string-length($t/@ref) + string-length($t/@flexibility) }
        }
        {
            for $lc at $step in ($t//element[@contains] | $t//include[@ref])
            let $xid    := if ($lc[self::element]) then $lc/@contains else $lc/@ref
            let $lcby   := if ($lc[self::element]) then map:get($i18nmap, 'contains') else $lc/name()
            let $xflx   := if ($lc[@flexibility]) then $lc/@flexibility else 'dynamic'
            let $lct    := templ:getTemplateByRef($xid,$xflx,$projectPrefix)/*/template[@id]
            return 
                if ($templatesSoFar[.=$lct/concat(@id,@effectiveDate)]) then (
                    <template recurse="true">
                    {
                        $lct/(@id | @name | @displayName),
                        attribute effectiveDate {local:showDate($lct/@effectiveDate)},
                        attribute by {$by},
                        attribute len {
                            max((string-length($lct/@id),string-length($lct/@name))) + 
                            string-length($lct/@effectiveDate) + 
                            string-length(map:get($i18nmap, 'contains')) + 
                            1
                        }
                    }
                    </template>
                ) else (
                    local:templateScan ($lct, $projectPrefix, $lcby, $indent + 1, $ylevel + $step, ($templatesSoFar, $lct/concat(@id,@effectiveDate)))
                )
        }
        </include>
    ) else ()
};

declare %private function local:chainCopy1 ($t as element(), $indent as xs:int) as element() {
    element {$t/name()} {
        $t/@*,
        attribute indent {$indent},
        for $i at $step in $t/*
        return local:chainCopy1($i, $indent+1)
    }
};

declare %private function local:chainCopy2 ($t as element(), $pos as xs:int) as element() {
    element {$t/name()} {
        $t/@*,
        attribute pos {$pos},
        for $i at $step in $t//*
        let $oname := $i/name()
        return element {$oname} {
            $i/@*,
            attribute pos {$step},
            attribute connector {
                if ($t//*[($step - 1)]/@indent = $t//*[$step]/@indent) then 2 
                else if ($t//*[($step - 1)]/@indent < $t//*[$step]/@indent) then 1
                else if ($t//*[($step - 1)]/@indent > $t//*[$step]/@indent) then 4 + 1
                else 0
            }
        }
    }
};

declare %private function local:drawbox ($t as element(), $ty as xs:string, $classboxWidth as xs:int) as element()* {
let $txt    := concat ($t/@id,' (', $t/@effectiveDate,')')
let $tn     := concat (if (string-length($t/@displayName)>0) then $t/@displayName else $t/@name, $t/@contains, $t/@ref)
let $xx     := 10 + 15 * $t/@indent
let $yy     := -20 + 45 * $t/@pos
let $stripx := $xx - 10
let $stripy := $yy + 18
(:
    get vertical angle connector offset:
    0: no angle at all
    1: short angle connection, first item under parent
    2: long angle connection, second and later item under parent
    3: multiple blocks angle connection, back to parent level
:)
let $path := if ($t/@connector = 1) then (
        <svg:path>
        {
            <svg:path style="fill:none;stroke:#000000;stroke-width:0.5px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"
                      d="m {$stripx}, {$stripy - 25} v 25" id="path2872"/>,
            <svg:path style="fill:none;stroke:#000000;stroke-width:0.5px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"
                      d="m {$stripx}, {$stripy} h 10" id="path2872"/>
        }
        </svg:path>
    ) else if ($t/@connector = 2) then (
        <svg:path>
        {
            <svg:path style="fill:none;stroke:#000000;stroke-width:0.5px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"
                      d="m {$stripx}, {$stripy - 45} v 45" id="path2872"/>,
            <svg:path style="fill:none;stroke:#000000;stroke-width:0.5px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"
                      d="m {$stripx}, {$stripy} h 10" id="path2872"/>
        }
        </svg:path>
    ) else if ($t/@connector > 2) then (
        <svg:path>
        {
            <svg:path style="fill:none;stroke:#000000;stroke-width:0.5px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"
                      d="m {$stripx}, {$stripy - $t/@connector * 25 - 10} v {$t/@connector * 25 + 10}" id="path2872"/>,
            <svg:path style="fill:none;stroke:#000000;stroke-width:0.5px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"
                      d="m {$stripx}, {$stripy} h 10" id="path2872"/>
        }
        </svg:path>
    )
    else (
        <svg:path/>
    )
return (
    $path/*,
    <svg:rect x="{$xx}" y="{$yy}" stroke-width="0.25" stroke-miterlimit="10" width="{$classboxWidth}" height="37.668" filter="url(#shadow)" class="class-box{if ($t[@recurse]) then (' class-box-recurse') else ()}"/>,
    <svg:text transform="matrix(1 0 0 1 {$xx+5} {$yy+15})" class="normal-start">
        <svg:tspan x="0" y="0"><svg:tspan class="text-bold">{$tn}</svg:tspan> ({$ty})</svg:tspan>
        <svg:tspan x="0" y="14">{$txt}</svg:tspan>
    </svg:text>
    )
};

declare %private function local:drawtree ($t as element()*, $classboxWidth as xs:int) as element()* {
    if ($t[self::tree]) then (
         for $i at $step in $t/*
         return local:drawtree($i, $classboxWidth)
    ) else (
        for $i at $step in $t
        return (
            local:drawbox ($i, if ($i/@by) then $i/@by else name($i) , $classboxWidth),
            for $j at $step in $i/*
            return local:drawtree($j, $classboxWidth)
        )
    )
};

declare %private function local:apply-hgraph-stylesheet($input as node(), $format as xs:string) {
let $xsltParameters :=
    <parameters>
        <param name="outputformat"      value="{$format}"/>
        <param name="coretableonly"     value="false"/>
    </parameters>

let $xslt := 
    (:xs:anyURI(concat('xmldb:exist://', $get:strDecorCore, '/Template2list8hgraph.xsl')):)
    (:xs:anyURI('https://art-decor.org/ADAR-dev/rv/Template2list8hgraph.xsl'):)
    xs:anyURI('https://art-decor.org/ADAR/rv/Template2list8hgraph.xsl')

let $xslt := xs:anyURI(concat('xmldb:exist://', $get:strDecorCore, '/Template2list8hgraph.xsl'))

return 
    transform:transform($input, $xslt, $xsltParameters)
};

let $projectPrefix          := 
    if (request:exists()) then 
        if (request:get-parameter-names()[. = 'project']) then 
            request:get-parameter('project', ())
        else (
            request:get-parameter('prefix', ())
        )
    else ()
let $templateId             := if (request:exists()) then request:get-parameter('id', ()) else ()
let $templateEffectiveDate  := if (request:exists()) then request:get-parameter('effectiveDate', 'dynamic') else ()
let $format                 := if (request:exists()) then request:get-parameter('format','svg') else ('svg')

let $classboxHeight         := 150
let $concept                := 'ABC'
let $absolutepos            := 1

let $templatesById          := 
    if (string-length($templateId)>0 and string-length($projectPrefix)>0) then
        templ:getTemplateById($templateId, $templateEffectiveDate, $projectPrefix)/*/template[@id]
    else ()
    
let $templatesById          := 
    if (empty($templatesById)) then templ:getTemplateById($templateId, $templateEffectiveDate)/*/template[@id] (: fallback: get it anywhere :)
    else $templatesById

let $templatechain          := 
    if (count($templatesById)=1) then
        local:chainCopy2(local:chainCopy1(<tree>{local:templateScan ($templatesById, $projectPrefix, 'template', 1, 1, ())}</tree>, -1), 1)
    else ()

let $maxstrlen              := max($templatechain//@len)

return

if (empty($templatesById)) then
    (response:set-status-code(404), response:set-header('Content-Type','text/xml'), <error>{i18n:getMessage($docMessages,'errorRetrieveTemplateNoResults',$language, if (request:exists()) then request:get-query-string() else())}</error>)
else if (count($templatesById)>1) then
    (response:set-status-code(500), response:set-header('Content-Type','text/xml'), <error>{i18n:getMessage($docMessages,'errorRetrieveTemplateMultipleResults',$language, if (request:exists()) then request:get-query-string() else()), ' (', string-join($templatesById/@effectiveDate, ', '),')'}</error>)
(:
    xml format returns the flat template chain as use for drawing the graph
    ==========
    <x project="hl7ips-">
        <tree indent="-1" pos="1">
            <template id="2.16.840.1.113883.3.1937.777.13.10.1" name="IPSManufacturedProduct" displayName="IPS ManufacturedProduct" effectiveDate="2016‑11‑10T16:50:12" by="template" len="63" classification="cdaentrylevel" indent="0" pos="1" connector="0"/>
            <template id="2.16.840.1.113883.3.1937.777.13.10.2" name="IPSMedMaterial" displayName="IPS Manufactured Material" effectiveDate="2016‑11‑10T16:51:46" by="include" len="63" classification="cdaentrylevel" indent="1" pos="2" connector="1"/>
        </tree>
        <max>63</max>
    </x>
:)
else if ($format='xml') then (
    <x project="{$projectPrefix}">
    {
        $templatechain,
        <max>{$maxstrlen}</max>
    }
    </x>
    (:local:templateScan ($templatesById, $projectPrefix, 'template', 1, 1):)
    (:$templatesById:)
)
(:
    hlist format returns the raw hierarchical template chain including classification
    ==========
    <template id="2.16.840.1.113883.3.1937.777.13.10.1" name="IPSManufacturedProduct" displayName="IPS ManufacturedProduct" effectiveDate="2016‑11‑10T16:50:12" by="template" len="63" classification="cdaentrylevel">
        <template id="2.16.840.1.113883.3.1937.777.13.10.2" name="IPSMedMaterial" displayName="IPS Manufactured Material" effectiveDate="2016‑11‑10T16:51:46" by="include" len="63" classification="cdaentrylevel"/>
    </template>
:)
else if ($format='hlist') then (
    (: :)
    for $ur in local:templateScan ($templatesById, $projectPrefix, 'template', 1, 1, ())
    return $ur
    (: :)
    (:
    <x>{templ:getTemplateChain($projectPrefix, $templatesById, ())}</x>
    :)
)
else if ($format=('hgraph', 'hgraphwiki', 'wikilist', 'transclusionwikilist')) then (
(:
    hgraph format returns the hierarchical graph of the template chain including classification
    hgraphwiki is the same as hgraph but the OIDs of the templates are in Mediawiki link style [[1.2.3...]]
    transclusionwikilist returns the list of templates in Mediawiki transclusion style, sorted by classification
    wikilist returns the list of templates in Mediawiki list style, sorted by id
    ==========
:)
    let $h := response:set-header('Content-Type','text/html; charset=utf-8')
    let $r :=
        for $ur in local:templateScan ($templatesById, $projectPrefix, 'template', 1, 1, ())
        return $ur
    return local:apply-hgraph-stylesheet($r, $format)
)
else if (count($templatechain/*)=0) then ()
(:
    ...in all other cases draw the svg graph
:)
else (
    let $classboxWidth  := 30 + $maxstrlen*7

    let $height         := max($templatechain//@pos) * 47 + 50
    let $width          := max($templatechain//@indent) * 50 + $classboxWidth + 50
    
    return
    <svg xmlns="http://www.w3.org/2000/svg" id="svg2" version="1.1" width="{$width}" height="{$height+5}">
    
        <style type="text/css"><![CDATA[
          .normal-bold {
              font-size:11px;
              font-weight:bold;
              text-align:start;
              line-height:125%;
              text-anchor:middle;
              fill:#000000;
              fill-opacity:1;
              stroke:none;
              font-family: Verdana, Arial, sans-serif;
          }
        ]]>
        </style>
        <style type="text/css"><![CDATA[
          .text-bold {
              font-size:11px;
              font-weight:bold;
              line-height:125%;
              font-family: Verdana, Arial, sans-serif;
          }
        ]]>
        </style>
        <style type="text/css"><![CDATA[
          .normal-start {
              font-size:11px;
              text-align:start;
              font-weight:normal;
              text-anchor:start;
              fill:#000000;
              fill-opacity:1;
              stroke:none;
              font-family: Verdana, Arial, sans-serif;
          }
        ]]>
        </style>
        <style type="text/css"><![CDATA[
          .class-box {
              fill:#ffd7d8;
              fill-opacity:1;
              fill-rule:evenodd;
              stroke:#000000;
              stroke-width:0.2;
              stroke-linecap:butt;
              stroke-linejoin:miter;
              stroke-miterlimit:4;
              stroke-opacity:1;
              stroke-dasharray:none
          }
        ]]>
        </style>
        <style type="text/css"><![CDATA[
          .class-box-recurse {
              fill:#EEC6C7;
          }
        ]]>
        </style>

        <defs>
            <filter id="shadow" height="200%" width="200%" y="0" x="0">
                <feOffset result="offOut" dx="3" dy="3" in="SourceGraphic"/>
                <feColorMatrix result="matrixOut" values="0.2 0 0 0 0 0 0.2 0 0 0 0 0 0.2 0 0 0 0 0 1 0" type="matrix" in="offOut"/>
                <feGaussianBlur result="blurOut" stdDeviation="2" in="matrixOut"/>
                <feBlend in2="blurOut" in="SourceGraphic" mode="normal"/>
            </filter>
        </defs>

        <rect style="fill:#ffffff;fill-opacity:1;stroke:#000000;stroke-width:0"
                  id="backgroundObject" width="{$width}" height="{$height+5}" x="0" y="0">
            <desc>Background rectangle in white to avoid transparency.</desc>
        </rect>
            <!--<path style="fill:none;stroke:#000000;stroke-width:0.5px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"
                      d="m 15, 30 h {$classboxWidth - 10}" id="path2872">
            </path>-->
        {
            local:drawtree ($templatechain, $classboxWidth)
        }
        <!--
        <text transform="matrix(1 0 0 1 15 25)" class="normal-start">
            <tspan x="0" y="0"><tspan class="text-bold">Arztmeldung6IfSG </tspan>(template)</tspan>
            <tspan x="0" y="14">{$templateId} as of {$templateEffectiveDate}</tspan>
        </text>-->
    </svg>
)