xquery version "3.1";
(:
    ART-DECOR® STANDARD COPYRIGHT AND LICENSE NOTE
    Copyright © ART-DECOR Expert Group and ART-DECOR Open Tools GmbH
    see https://docs.art-decor.org/copyright and https://docs.art-decor.org/licenses

    This file is part of the ART-DECOR® tools suite.
:)

import module namespace dsapi       = "http://art-decor.org/ns/api/dataset" at "../../../api/modules/dataset-api.xqm";
import module namespace scapi       = "http://art-decor.org/ns/api/scenario" at "../../../api/modules/scenario-api.xqm";
import module namespace deapi       = "http://art-decor.org/ns/api/concept" at "../../../api/modules/concept-api.xqm";
import module namespace utillib      = "http://art-decor.org/ns/api/util" at "../../../api/modules/library/util-lib.xqm";
import module namespace router      = "http://e-editiones.org/roaster/router";
import module namespace errors      = "http://e-editiones.org/roaster/errors";
declare namespace output = "http://www.w3.org/2010/xslt-xquery-serialization";

declare option exist:timeout "180000";  (: see https://art-decor.atlassian.net/browse/AD30-2071 :)

let $id                         := if (request:exists()) then request:get-parameter('id',())[string-length()>0][1] else '2.16.840.1.113883.2.4.3.11.60.90.77.1.5'
let $effectiveDate              := if (request:exists()) then request:get-parameter('effectiveDate',()) else ()
let $conceptId                  := if (request:exists()) then request:get-parameter('conceptId',())[string-length()>0][1] else '2.16.840.1.113883.2.4.3.11.60.90.77.1.5'
let $conceptEffectiveDate       := if (request:exists()) then request:get-parameter('conceptEffectiveDate',())[string-length()>0] else ()
let $community                  := if (request:exists()) then request:get-parameter('community',())[string-length()>0] else ()
let $projectPrefix              := if (request:exists()) then request:get-parameter('prefix',())[not(. = '')] else ()
let $projectVersion             := if (request:exists()) then request:get-parameter('version',())[not(. = '')] else ()
let $seetype                    := if (request:exists()) then request:get-parameter('seetype', 'live-services') else ('live-services')
let $format                     := if (request:exists()) then request:get-parameter('format','html') else 'xml'
let $hidecolumns                := if (request:exists()) then request:get-parameter('hidecolumns','') else ()
let $language                   := if (request:exists()) then request:get-parameter('language',()) else ()
let $ui-language                := if (request:exists()) then request:get-parameter('ui',()) else ()
let $download                   := if (request:exists()) then request:get-parameter('download','false')='true' else false()
(:
    retrieveTransaction gets 
    - a transaction OR
    - a dataset OR
    - a concept
:)

let $check                      := if ($id and $effectiveDate) then () else if ($conceptId and $conceptEffectiveDate) then () else (
    error($errors:BAD_REQUEST, 'Parameters id and effectiveDate OR parameters conceptIid and conceptEffectiveDate are required')
) 

let $datasetOrTransaction       := if ($id) then utillib:getTransaction($id, $effectiveDate, $projectPrefix, $projectVersion, $language) else ()
let $datasetOrTransaction       := if ($datasetOrTransaction) then $datasetOrTransaction else if ($id) then utillib:getDataset($id, $effectiveDate, $projectPrefix, $projectVersion, $language) else ()

let $isDataset                  := exists($datasetOrTransaction[self::dataset])
let $isTransaction              := exists($datasetOrTransaction[self::transaction])
let $isConcept                  := if (empty($datasetOrTransaction) or empty($conceptId)) then false() else exists($datasetOrTransaction//concept[@id = $conceptId])

(: hlist exists so don't move it to list anymore, see KH AD30-2038
let $format                     := if ($format = 'hlist') then 'list' else $format 
:)

let $result                     :=
    if ($isConcept) then (
        switch ($format)
        case 'html'
        case 'list'
        case 'hlist'
        return (
            deapi:getConceptView(map {
                "parameters": map {
                    "datasetOrTransactionId" : $id,
                    "datasetOrTransactionEd" : $effectiveDate,
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "ui-language": $ui-language,
                    "community" : $community,
                    "hidecolumns": $hidecolumns,
                    "format" : $format,
                    "download" : $download,
                    "id": $conceptId,
                    "effectiveDate": $conceptEffectiveDate
                    }
                }
            )
        )
        default return (
            deapi:getConceptExtract(map {
                "parameters": map {
                    "datasetOrTransactionId" : $id,
                    "datasetOrTransactionEd" : $effectiveDate,
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "community" : $community,
                    "format" : $format,
                    "download" : $download,
                    "id": $conceptId,
                    "effectiveDate": $conceptEffectiveDate
                    }
                }
            )
        )
    )
    else
    if ($isDataset) then (
        switch ($format)
        case 'html'
        case 'list'
        case 'hlist'
        return (
            dsapi:getDatasetView(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "ui-language": $ui-language,
                    "community" : $community,
                    "hidecolumns": $hidecolumns,
                    "seetype": $seetype,
                    "format" : $format,
                    "download" : $download,
                    "id": $id,
                    "effectiveDate": $effectiveDate
                    }
                }
            )
        )
        default return (
            dsapi:getDatasetExtract(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "community" : $community,
                    "format" : $format,
                    "download" : $download,
                    "id": $id,
                    "effectiveDate": $effectiveDate
                    }
                }
            )
        )
    )
    else if ($isTransaction) then (
        switch ($format)
        case 'html'
        case 'list'
        case 'hlist'
        return (
            scapi:getTransactionView(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "ui-language": $ui-language,
                    "community" : $community,
                    "hidecolumns": $hidecolumns,
                    "format" : $format,
                    "download" : $download,
                    "id": $id,
                    "effectiveDate": $effectiveDate
                    }
                }
            )
        )
        default return (
            scapi:getTransactionExtract(map {
                "parameters": map {
                    "project": $projectPrefix,
                    "release": $projectVersion,
                    "language": $language,
                    "community" : $community,
                    "format" : $format,
                    "download" : $download,
                    "id": $id,
                    "effectiveDate": $effectiveDate
                    }
                }
            )
        )
    )
    else if ($datasetOrTransaction) then 
        error($errors:BAD_REQUEST, 'Object not a transaction, dataset or concept. Found: ' || string-join($datasetOrTransaction/local-name(), ', '))
    else (
        if (response:exists()) then response:set-status-code(404) else ()
    )
    
return 
    typeswitch ($result)
    case map() return (
        if (response:exists()) then response:set-status-code(($result?($router:RESPONSE_CODE), 200)[1]) else (),
        if ($format = 'json') then util:declare-option("output:method", 'json') else (),
        $result?($router:RESPONSE_BODY)
    )
    default return (
        switch ($format)
        case 'json' return serialize($result, map{"method": "json"})
        default return $result
    )
